/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db;

import ch.ergon.adam.core.db.interfaces.MigrationStrategy;
import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.schema.Constraint;
import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.PrimaryKeyConstraint;
import ch.ergon.adam.core.db.schema.Relation;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.core.helper.Pair;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultMigrationStrategy
implements MigrationStrategy {
    Set<Table> tablesToCreate = new LinkedHashSet<Table>();
    Set<Table> tablesToDrop = new LinkedHashSet<Table>();
    Set<Pair<Table, Table>> tablesToRecreate = new LinkedHashSet<Pair<Table, Table>>();
    Set<Pair<Table, Table>> tablesToRename = new LinkedHashSet<Pair<Table, Table>>();
    Set<Index> indexesToCreate = new LinkedHashSet<Index>();
    Set<Index> indexesToDrop = new LinkedHashSet<Index>();
    Set<ForeignKey> foreignKeysToCreate = new LinkedHashSet<ForeignKey>();
    Set<ForeignKey> foreignKeysToDrop = new LinkedHashSet<ForeignKey>();
    Set<Field> fieldsToDrop = new LinkedHashSet<Field>();
    Set<Field> fieldsToAdd = new LinkedHashSet<Field>();
    Set<Field> fieldsToChangeDefault = new LinkedHashSet<Field>();
    Set<View> viewsToCreate = new LinkedHashSet<View>();
    Set<View> viewsToDrop = new LinkedHashSet<View>();
    Set<DbEnum> enumsToCreate = new LinkedHashSet<DbEnum>();
    Set<DbEnum> enumsToUpdate = new LinkedHashSet<DbEnum>();
    Set<Field> fieldsToChangeTypeForEnumMigration = new LinkedHashSet<Field>();
    Set<DbEnum> enumsToDrop = new LinkedHashSet<DbEnum>();
    Set<Constraint> constraintsToDrop = new LinkedHashSet<Constraint>();
    Set<Constraint> constraintsToCreate = new LinkedHashSet<Constraint>();
    Set<Sequence> sequencesToCreate = new LinkedHashSet<Sequence>();
    Set<Sequence> sequencesToDrop = new LinkedHashSet<Sequence>();
    private Schema sourceSchema;
    private Schema targetSchema;

    @Override
    public void tableAdded(Table newTable) {
        this.tablesToCreate.add(newTable);
        this.indexesToCreate.addAll(newTable.getIndexes());
        this.foreignKeysToCreate.addAll(newTable.getForeignKeys());
        this.constraintsToCreate.addAll(newTable.getConstraints());
    }

    @Override
    public void tableRenamed(Table oldTable, Table newTable) {
        this.tablesToRename.add(new Pair<Table, Table>(oldTable, newTable));
    }

    @Override
    public void tableRemoved(Table oldTable) {
        this.tablesToDrop.stream().flatMap(table -> table.getFields().stream()).flatMap(field -> field.getReferencingIndexes().stream()).forEach(index -> this.foreignKeysToDrop.addAll(index.getReferencingForeignKeys()));
        this.tablesToDrop.add(oldTable);
    }

    @Override
    public void fieldAdded(Field newField) {
        Table sourceTable = this.getPreviousTable(newField.getTable());
        if (newField.getIndex() < sourceTable.getFields().size()) {
            this.recreateTable(sourceTable, newField.getTable());
        } else if (!newField.isNullable() && newField.getDefaultValue() == null) {
            this.recreateTable(sourceTable, newField.getTable());
        } else {
            this.fieldsToAdd.add(newField);
        }
    }

    private Table getPreviousTable(Table newTable) {
        Table previousTable = this.sourceSchema.getTable(newTable.getName());
        if (previousTable == null && newTable.getPreviousName() != null) {
            previousTable = this.sourceSchema.getTable(newTable.getPreviousName());
        }
        return previousTable;
    }

    private void recreateTable(Table sourceTable, Table targetTable) {
        sourceTable.getIndexes().forEach(this::dropIndex);
        this.foreignKeysToDrop.addAll(sourceTable.getForeignKeys());
        for (Field newField : targetTable.getFields()) {
            newField.getReferencingIndexes().forEach(newIndex -> {
                this.indexesToCreate.add((Index)newIndex);
                this.foreignKeysToCreate.addAll(newIndex.getReferencingForeignKeys());
            });
        }
        this.constraintsToCreate.addAll(targetTable.getConstraints());
        this.foreignKeysToCreate.addAll(targetTable.getForeignKeys());
        this.tablesToRecreate.add(new Pair<Table, Table>(sourceTable, targetTable));
    }

    @Override
    public void fieldRemoved(Field oldField) {
        this.dropField(oldField);
    }

    private void dropField(Field oldField) {
        this.fieldsToDrop.add(oldField);
        oldField.getReferencingIndexes().forEach(this::dropIndex);
    }

    @Override
    public void fieldRenamed(Field oldField, Field newField) {
        this.recreateTable(oldField.getTable(), newField.getTable());
    }

    @Override
    public void fieldIndexChange(Field oldField, Field newField) {
        this.recreateTable(oldField.getTable(), newField.getTable());
    }

    @Override
    public void fieldDefaultChanged(Field oldField, Field newField) {
        this.fieldsToChangeDefault.add(newField);
    }

    @Override
    public void fileTypeChanged(Field oldField, Field newField) {
        this.recreateTable(oldField.getTable(), newField.getTable());
    }

    @Override
    public void indexAdded(Index newIndex) {
        this.indexesToCreate.add(newIndex);
    }

    @Override
    public void indexUpdated(Index oldIndex, Index newIndex) {
        this.indexesToCreate.add(newIndex);
        this.dropIndex(oldIndex);
        this.foreignKeysToCreate.addAll(newIndex.getReferencingForeignKeys());
    }

    private void dropIndex(Index oldIndex) {
        this.foreignKeysToDrop.addAll(oldIndex.getReferencingForeignKeys());
        if (oldIndex.isPrimary()) {
            this.constraintsToDrop.addAll(oldIndex.getTable().getConstraints().stream().filter(constraint -> constraint instanceof PrimaryKeyConstraint).collect(Collectors.toList()));
        } else {
            this.indexesToDrop.add(oldIndex);
        }
    }

    @Override
    public void indexRemoved(Index oldIndex) {
        this.dropIndex(oldIndex);
    }

    @Override
    public void foreignKeyAdded(ForeignKey newForeignKey) {
        this.foreignKeysToCreate.add(newForeignKey);
    }

    @Override
    public void foreignKeyUpdated(ForeignKey oldForeignKey, ForeignKey newForeignKey) {
        this.foreignKeysToCreate.add(newForeignKey);
        this.foreignKeysToDrop.add(oldForeignKey);
    }

    @Override
    public void foreignKeyRemoved(ForeignKey oldForeignKey) {
        this.foreignKeysToDrop.add(oldForeignKey);
    }

    @Override
    public void viewAdded(View newView) {
        this.viewsToCreate.add(newView);
    }

    @Override
    public void viewRemoved(View oldView) {
        this.viewsToDrop.add(oldView);
    }

    @Override
    public void viewUpdated(View oldView, View newView) {
        this.viewRemoved(oldView);
        this.viewAdded(newView);
    }

    @Override
    public void setSourceSchema(Schema sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    @Override
    public void setTargetSchema(Schema targetSchema) {
        this.targetSchema = targetSchema;
    }

    @Override
    public void enumAdded(DbEnum newEnum) {
        this.enumsToCreate.add(newEnum);
    }

    @Override
    public void enumRemoved(DbEnum oldEnum) {
        this.enumsToDrop.add(oldEnum);
    }

    @Override
    public void enumUpdated(DbEnum oldEnum, DbEnum newEnum) {
        this.enumsToUpdate.add(oldEnum);
        this.enumsToCreate.add(newEnum);
        this.fieldsToChangeTypeForEnumMigration.addAll(oldEnum.getReferencingFields());
    }

    @Override
    public void constraintAdded(Constraint newConstraint) {
        if (newConstraint instanceof PrimaryKeyConstraint) {
            return;
        }
        this.constraintsToCreate.add(newConstraint);
    }

    @Override
    public void constraintRemoved(Constraint oldConstraint) {
        if (oldConstraint instanceof PrimaryKeyConstraint) {
            return;
        }
        this.constraintsToDrop.add(oldConstraint);
    }

    @Override
    public void constraintUpdated(Constraint oldConstraint, Constraint newConstraint) {
        this.constraintRemoved(oldConstraint);
        this.constraintAdded(newConstraint);
    }

    @Override
    public void sequenceAdded(Sequence sequence) {
        this.sequencesToCreate.add(sequence);
    }

    @Override
    public void sequenceRemoved(Sequence sequence) {
        this.sequencesToDrop.add(sequence);
    }

    @Override
    public void sequenceUpdated(Sequence sourceSequence, Sequence targetSequence) {
        this.sequencesToDrop.add(sourceSequence);
        this.sequencesToCreate.add(targetSequence);
    }

    @Override
    public void apply(SchemaSink sink) {
        this.fixupSinkSpecifics(sink);
        this.cleanupForRecreatedTables();
        this.recreateDependentViews();
        this.viewsToDrop.stream().sorted(Comparator.comparing(this::maxDependencyDepth)).forEach(sink::dropView);
        this.foreignKeysToDrop.forEach(sink::dropForeignKey);
        this.constraintsToDrop.forEach(sink::dropConstraint);
        this.indexesToDrop.forEach(sink::dropIndex);
        this.sequencesToDrop.forEach(sink::dropSequence);
        this.fieldsToChangeTypeForEnumMigration.forEach(field -> {
            sink.dropDefault((Field)field);
            sink.changeFieldType((Field)field, (Field)field, DataType.CLOB);
        });
        this.enumsToUpdate.forEach(sink::dropEnum);
        this.enumsToCreate.forEach(sink::createEnum);
        this.fieldsToChangeTypeForEnumMigration.forEach(field -> {
            sink.changeFieldType((Field)field, (Field)field, field.getDataType());
            sink.setDefault((Field)field);
        });
        this.tablesToRename.forEach(pair -> sink.renameTable((Table)pair.getFirst(), ((Table)pair.getSecond()).getName()));
        this.fieldsToAdd.forEach(sink::addField);
        this.tablesToCreate.forEach(sink::createTable);
        this.tablesToRecreate.forEach(pair -> this.applyTableRecreate((Table)pair.getFirst(), (Table)pair.getSecond(), sink));
        this.fieldsToDrop.stream().forEach(fieldToDrop -> sink.dropField((Field)fieldToDrop, this.getNewTableForOldField((Field)fieldToDrop)));
        this.tablesToDrop.forEach(sink::dropTable);
        this.enumsToDrop.forEach(sink::dropEnum);
        this.sequencesToCreate.forEach(sink::createSequence);
        this.fieldsToChangeDefault.forEach(sink::setDefault);
        this.indexesToCreate.forEach(sink::createIndex);
        this.constraintsToCreate.forEach(sink::createConstraint);
        this.foreignKeysToCreate.forEach(sink::createForeignKey);
        this.viewsToCreate.stream().sorted(Comparator.comparing(this::minDependencyDepth)).forEach(sink::createView);
    }

    private void fixupSinkSpecifics(SchemaSink sink) {
        if (!sink.supportAlterAndDropField()) {
            Table newTable;
            for (Field field : this.fieldsToDrop) {
                newTable = this.getNewTableForOldField(field);
                this.recreateTable(field.getTable(), newTable);
            }
            for (Field field : this.fieldsToChangeDefault) {
                newTable = this.getNewTableForOldField(field);
                this.recreateTable(field.getTable(), newTable);
            }
            this.fieldsToDrop.clear();
            this.fieldsToChangeDefault.clear();
        }
    }

    private Table getNewTableForOldField(Field field) {
        String oldTableName = field.getTable().getName();
        Table newTable = this.tablesToRename.stream().filter(pair -> ((Table)pair.getFirst()).getName().equals(oldTableName)).map(pair -> (Table)pair.getSecond()).findFirst().orElse(this.targetSchema.getTable(oldTableName));
        return newTable;
    }

    private int minDependencyDepth(Relation relation) {
        return -this.maxDependencyDepth(relation);
    }

    private int maxDependencyDepth(Relation relation) {
        if (relation instanceof Table) {
            return 0;
        }
        return ((View)relation).getBaseRelations().stream().map(this::maxDependencyDepth).min(Integer::compareTo).orElse(0) - 1;
    }

    private void recreateDependentViews() {
        Stream.concat(this.tablesToRecreate.stream().map(Pair::getFirst), this.viewsToDrop.stream()).distinct().forEach(this::recreateDependentView);
    }

    private void recreateDependentView(Relation relation) {
        relation.getDependentViews().forEach(view -> {
            if (this.viewsToCreate.stream().noneMatch(newView -> newView.getName().equals(view.getName()))) {
                this.viewsToDrop.add((View)view);
                View targetView = this.targetSchema.getView(view.getName());
                if (targetView != null) {
                    this.viewsToCreate.add(targetView);
                }
            }
            this.recreateDependentView((Relation)view);
        });
    }

    private void cleanupForRecreatedTables() {
        for (Pair<Table, Table> recreatePair : this.tablesToRecreate) {
            this.tablesToRename.removeIf(pair -> ((Table)pair.getSecond()).equals(recreatePair.getSecond()));
            this.fieldsToAdd.removeIf(field -> field.getTable() == recreatePair.getSecond());
            this.fieldsToDrop.removeIf(field -> field.getTable() == recreatePair.getFirst());
            this.fieldsToChangeDefault.removeIf(field -> field.getTable() == recreatePair.getSecond());
        }
    }

    private void applyTableRecreate(Table sourceTable, Table targetTable, SchemaSink sink) {
        String insertSourceTableName;
        if (sourceTable.getName().equals(targetTable.getName())) {
            insertSourceTableName = "tmp_" + sourceTable.getName();
            sink.dropSequencesAndDefaults(sourceTable);
            sink.renameTable(sourceTable, insertSourceTableName);
        } else {
            insertSourceTableName = sourceTable.getName();
        }
        sink.createTable(targetTable);
        sink.copyData(sourceTable, targetTable, insertSourceTableName);
        sink.dropTable(new Table(insertSourceTableName));
    }
}

