/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db;

import ch.ergon.adam.core.db.interfaces.MigrationStrategy;
import ch.ergon.adam.core.db.schema.Constraint;
import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.PrimaryKeyConstraint;
import ch.ergon.adam.core.db.schema.RuleConstraint;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.core.helper.CollectorsHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SchemaDiffExtractor {
    private static final List<DataType> DATA_TYPES_WITH_IGNORED_FIELD_SIZE = Arrays.asList(DataType.TIMESTAMPWITHTIMEZONE, DataType.LOCALDATE, DataType.LOCALDATETIME, DataType.LOCALTIME, DataType.OFFSETDATETIME, DataType.OFFSETTIME, DataType.OFFSETTIME, DataType.TIMESTAMP);
    private final Schema target;
    private final Schema source;

    public SchemaDiffExtractor(Schema source, Schema target) {
        this.source = source;
        this.target = target;
    }

    private <T extends SchemaItem> void addedRemovedUpdated(Collection<T> sourceList, Collection<T> targetList, Consumer<T> addedHandler, Consumer<T> removedHandler, BiConsumer<T, T> processHandler) {
        this.addedRemovedUpdated(sourceList, targetList, targetItem -> null, addedHandler, removedHandler, processHandler);
    }

    private <T extends SchemaItem> void addedRemovedUpdated(Collection<T> sourceList, Collection<T> targetList, Function<T, String> previousObjectNameFunction, Consumer<T> addedHandler, Consumer<T> removedHandler, BiConsumer<T, T> processHandler) {
        Map sourceMap = sourceList.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        Map targetMap = targetList.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        Map previousNameToTargetItem = targetList.stream().filter(targetItem -> !sourceMap.containsKey(targetItem.getName())).filter(targetItem -> !targetMap.containsKey(previousObjectNameFunction.apply(targetItem))).filter(targetItem -> sourceMap.containsKey(previousObjectNameFunction.apply(targetItem))).collect(CollectorsHelper.toLinkedMap(previousObjectNameFunction::apply, Function.identity()));
        sourceList.stream().filter(sourceItem -> !targetMap.containsKey(sourceItem.getName())).filter(sourceItem -> !previousNameToTargetItem.containsKey(sourceItem.getName())).forEach(removedHandler::accept);
        targetList.stream().filter(targetItem -> !sourceMap.containsKey(targetItem.getName())).filter(targetItem -> !previousNameToTargetItem.containsValue(targetItem)).forEach(addedHandler::accept);
        targetList.stream().filter(item -> sourceMap.get(item.getName()) != null).forEach(targetItem -> {
            SchemaItem sourceItem = (SchemaItem)sourceMap.get(targetItem.getName());
            processHandler.accept(sourceItem, targetItem);
        });
        previousNameToTargetItem.values().forEach(targetItem -> {
            SchemaItem sourceItem = (SchemaItem)sourceMap.get(previousObjectNameFunction.apply(targetItem));
            processHandler.accept(sourceItem, targetItem);
        });
    }

    public void process(MigrationStrategy strategy) {
        this.addedRemovedUpdated(this.source.getTables(), this.target.getTables(), Table::getPreviousName, strategy::tableAdded, strategy::tableRemoved, (sourceTable, targetTable) -> this.processTable((Table)sourceTable, (Table)targetTable, strategy));
        this.addedRemovedUpdated(this.source.getViews(), this.target.getViews(), strategy::viewAdded, strategy::viewRemoved, (sourceView, targetView) -> this.processView((View)sourceView, (View)targetView, strategy));
        this.addedRemovedUpdated(this.source.getEnums(), this.target.getEnums(), strategy::enumAdded, strategy::enumRemoved, (sourceEnum, targetEnum) -> this.processEnum((DbEnum)sourceEnum, (DbEnum)targetEnum, strategy));
        this.addedRemovedUpdated(this.source.getSequences(), this.target.getSequences(), strategy::sequenceAdded, strategy::sequenceRemoved, (sourceSequence, targetSequence) -> this.processSequence((Sequence)sourceSequence, (Sequence)targetSequence, strategy));
    }

    private void processSequence(Sequence sourceSequence, Sequence targetSequence, MigrationStrategy strategy) {
        if (targetSequence.getIncrement() != null && !targetSequence.getIncrement().equals(sourceSequence.getIncrement()) || targetSequence.getMaxValue() != null && !targetSequence.getMaxValue().equals(sourceSequence.getMaxValue()) || targetSequence.getMinValue() != null && !targetSequence.getMinValue().equals(sourceSequence.getMinValue()) || targetSequence.getStartValue() != null && !targetSequence.getStartValue().equals(sourceSequence.getStartValue())) {
            strategy.sequenceUpdated(sourceSequence, targetSequence);
        }
    }

    private void processView(View sourceView, View targetView, MigrationStrategy strategy) {
        if (!Objects.equals(sourceView.getViewDefinition(), targetView.getViewDefinition())) {
            strategy.viewUpdated(sourceView, targetView);
        }
    }

    private void processEnum(DbEnum sourceEnum, DbEnum targetEnum, MigrationStrategy strategy) {
        if (!Arrays.equals(sourceEnum.getValues(), targetEnum.getValues())) {
            strategy.enumUpdated(sourceEnum, targetEnum);
        }
    }

    private void processTable(Table sourceTable, Table targetTable, MigrationStrategy strategy) {
        if (!Objects.equals(sourceTable.getName(), targetTable.getName())) {
            strategy.tableRenamed(sourceTable, targetTable);
        }
        this.addedRemovedUpdated(sourceTable.getFields(), targetTable.getFields(), Field::getSqlForNew, strategy::fieldAdded, strategy::fieldRemoved, (sourceField, targetField) -> this.processField((Field)sourceField, (Field)targetField, strategy));
        this.addedRemovedUpdated(sourceTable.getIndexes(), targetTable.getIndexes(), strategy::indexAdded, strategy::indexRemoved, (sourceIndex, targetIndex) -> this.processIndexes((Index)sourceIndex, (Index)targetIndex, strategy));
        this.addedRemovedUpdated(sourceTable.getForeignKeys(), targetTable.getForeignKeys(), strategy::foreignKeyAdded, strategy::foreignKeyRemoved, (sourceFK, targetFK) -> this.processForeignKey((ForeignKey)sourceFK, (ForeignKey)targetFK, strategy));
        List sourceConstraints = sourceTable.getConstraints().stream().filter(c -> !(c instanceof PrimaryKeyConstraint)).collect(Collectors.toList());
        List targetConstraints = targetTable.getConstraints().stream().filter(c -> !(c instanceof PrimaryKeyConstraint)).collect(Collectors.toList());
        this.addedRemovedUpdated(sourceConstraints, targetConstraints, strategy::constraintAdded, strategy::constraintRemoved, (sourceConstraint, targetConstraint) -> this.processConstraint((Constraint)sourceConstraint, (Constraint)targetConstraint, strategy));
    }

    private void processConstraint(Constraint sourceConstraint, Constraint targetConstraint, MigrationStrategy strategy) {
        if (sourceConstraint instanceof RuleConstraint) {
            RuleConstraint sourceRuleConstraint = (RuleConstraint)sourceConstraint;
            RuleConstraint targetRuleConstraint = (RuleConstraint)targetConstraint;
            if (!Objects.equals(sourceRuleConstraint.getRule(), targetRuleConstraint.getRule())) {
                strategy.constraintUpdated(sourceConstraint, targetConstraint);
            }
        }
    }

    private void processField(Field sourceField, Field targetField, MigrationStrategy strategy) {
        boolean fieldSizeChange;
        if (!Objects.equals(sourceField.getName(), targetField.getName())) {
            strategy.fieldRenamed(sourceField, targetField);
        }
        if (!Objects.equals(sourceField.getDefaultValue(), targetField.getDefaultValue())) {
            strategy.fieldDefaultChanged(sourceField, targetField);
        }
        if (sourceField.getIndex() != targetField.getIndex()) {
            strategy.fieldIndexChange(sourceField, targetField);
        }
        boolean sameEnum = sourceField.getDbEnum() == null && targetField.getDbEnum() == null || sourceField.getDbEnum() != null && targetField.getDbEnum() != null && Objects.equals(sourceField.getDbEnum().getName(), targetField.getDbEnum().getName());
        boolean bl = fieldSizeChange = !this.ignoreFieldSizeChange(targetField.getDataType()) && (!Objects.equals(sourceField.getLength(), targetField.getLength()) || !Objects.equals(sourceField.getPrecision(), targetField.getPrecision()) || !Objects.equals(sourceField.getScale(), targetField.getScale()));
        if (!Objects.equals((Object)sourceField.getDataType(), (Object)targetField.getDataType()) || !sameEnum || fieldSizeChange || sourceField.isSequence() != targetField.isSequence() || sourceField.isNullable() != targetField.isNullable() || sourceField.isArray() != targetField.isArray()) {
            strategy.fileTypeChanged(sourceField, targetField);
        }
    }

    private boolean ignoreFieldSizeChange(DataType dataType) {
        return DATA_TYPES_WITH_IGNORED_FIELD_SIZE.contains((Object)dataType);
    }

    private void processIndexes(Index sourceIndex, Index targetIndex, MigrationStrategy strategy) {
        if (sourceIndex.isUnique() != targetIndex.isUnique() || sourceIndex.isPrimary() != targetIndex.isPrimary() || !Arrays.equals(CollectorsHelper.createSchemaItemNameArray(sourceIndex.getFields()), CollectorsHelper.createSchemaItemNameArray(targetIndex.getFields()))) {
            strategy.indexUpdated(sourceIndex, targetIndex);
        }
    }

    private void processForeignKey(ForeignKey sourceFK, ForeignKey targetFK, MigrationStrategy strategy) {
        if (!sourceFK.getField().getName().equals(targetFK.getField().getName())) {
            strategy.foreignKeyUpdated(sourceFK, targetFK);
        }
    }
}

