/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db;

import ch.ergon.adam.core.MigrationConfiguration;
import ch.ergon.adam.core.db.DefaultMigrationStrategy;
import ch.ergon.adam.core.db.LoggingSinkWrapper;
import ch.ergon.adam.core.db.LoggingStrategyWrapper;
import ch.ergon.adam.core.db.SchemaDiffExtractor;
import ch.ergon.adam.core.db.SourceAndSinkFactory;
import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.interfaces.SchemaSource;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.SchemaItem;
import java.util.stream.Collectors;

public class SchemaMigrator {
    private SchemaSource source;
    private SchemaSource reference;
    private SchemaSink sink;
    private MigrationConfiguration configuration = new MigrationConfiguration();

    public static void migrate(String sourceUrl, String targetUrl) {
        SchemaMigrator.migrate(sourceUrl, targetUrl, new MigrationConfiguration());
    }

    public static void migrate(String sourceUrl, String targetUrl, MigrationConfiguration configuration) {
        SourceAndSinkFactory factory = SourceAndSinkFactory.getInstance();
        try (SchemaSource reference = factory.getSource(sourceUrl);
             SchemaSink sink = factory.getSink(targetUrl);
             SchemaSource source = factory.getSource(targetUrl);){
            SchemaMigrator schemaMigrator = new SchemaMigrator(source, reference, sink);
            schemaMigrator.setConfiguration(configuration);
            try {
                schemaMigrator.migrate();
            }
            catch (Exception e) {
                sink.rollback();
                throw e;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Migration failed.", e);
        }
    }

    public SchemaMigrator(SchemaSource source, SchemaSource reference, SchemaSink sink) {
        this.source = source;
        this.reference = reference;
        this.sink = new LoggingSinkWrapper(sink);
    }

    public void migrate() {
        Schema sourceSchema = this.source.getSchema();
        Schema targetSchema = this.reference.getSchema();
        sourceSchema = this.filter(sourceSchema);
        targetSchema = this.filter(targetSchema);
        this.sink.setTargetSchema(targetSchema);
        SchemaDiffExtractor diffExtractor = new SchemaDiffExtractor(sourceSchema, targetSchema);
        LoggingStrategyWrapper strategy = new LoggingStrategyWrapper(new DefaultMigrationStrategy());
        strategy.setSourceSchema(sourceSchema);
        strategy.setTargetSchema(targetSchema);
        diffExtractor.process(strategy);
        strategy.apply(this.sink);
        this.sink.commitChanges();
    }

    private Schema filter(Schema schema) {
        Schema filteredSchema = new Schema();
        filteredSchema.setTables(schema.getTables().stream().filter(this::isNameIncluded).collect(Collectors.toList()));
        filteredSchema.setViews(schema.getViews().stream().filter(this::isNameIncluded).collect(Collectors.toList()));
        filteredSchema.setSequences(schema.getSequences().stream().filter(this::isNameIncluded).collect(Collectors.toList()));
        filteredSchema.setEnums(schema.getEnums().stream().filter(this::isNameIncluded).collect(Collectors.toList()));
        return filteredSchema;
    }

    private boolean isNameIncluded(SchemaItem item) {
        if (this.configuration.getObjectNameExcludeList() != null && this.configuration.getObjectNameExcludeList().contains(item.getName())) {
            return false;
        }
        return this.configuration.getObjectNameIncludeList() == null || this.configuration.getObjectNameIncludeList().contains(item.getName());
    }

    public void setConfiguration(MigrationConfiguration configuration) {
        this.configuration = configuration;
    }
}

