/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db;

import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.interfaces.SchemaSource;
import ch.ergon.adam.core.db.interfaces.SourceAndSinkAdapter;
import ch.ergon.adam.core.db.interfaces.SqlExecutor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceAndSinkFactory {
    private final Logger logger = LoggerFactory.getLogger(SourceAndSinkFactory.class);
    private static SourceAndSinkFactory instance;
    private final List<SourceAndSinkAdapter> adapters;

    public static SourceAndSinkFactory getInstance() {
        if (instance == null) {
            SourceAndSinkFactory.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SourceAndSinkFactory();
        }
    }

    private SourceAndSinkFactory() {
        Reflections reflections = new Reflections("ch.ergon.adam", new Scanner[0]);
        Set adapterTypes = reflections.getSubTypesOf(SourceAndSinkAdapter.class);
        this.adapters = adapterTypes.stream().map(this::createAdapterInstance).filter(Objects::nonNull).collect(Collectors.toList());
        this.adapters.forEach(adapter -> this.logger.debug("New migration adapter registered [" + adapter.getClass().getName() + "]"));
    }

    private SourceAndSinkAdapter createAdapterInstance(Class<? extends SourceAndSinkAdapter> adapterClass) {
        try {
            Constructor<? extends SourceAndSinkAdapter> constructor = adapterClass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.warn("Could not create adapter factory [" + adapterClass.getName() + "]", (Throwable)e);
            return null;
        }
    }

    public SchemaSource getSource(String url) {
        return this.getAdapterForUrl(url).createSource(url);
    }

    public SchemaSink getSink(String url) {
        return this.getAdapterForUrl(url).createSink(url);
    }

    public SqlExecutor getSqlExecutor(String url) {
        return this.getAdapterForUrl(url).createSqlExecutor(url);
    }

    private SourceAndSinkAdapter getAdapterForUrl(String url) {
        List<SourceAndSinkAdapter> supportedAdapters = this.adapters.stream().filter(adapter -> adapter.supportsUrl(url)).collect(Collectors.toList());
        if (supportedAdapters.isEmpty()) {
            throw new RuntimeException("Could not find migration adapter for url [" + url + "]");
        }
        if (supportedAdapters.size() > 1) {
            this.logger.warn("Found multiple migration adapters for url [" + url + "]:");
            supportedAdapters.forEach(adapter -> this.logger.warn("\t" + adapter.getClass().getName()));
        }
        SourceAndSinkAdapter selectedAdapter = (SourceAndSinkAdapter)supportedAdapters.get(0);
        this.logger.debug("Using migration adapter [" + selectedAdapter.getClass().getName() + "] for url [" + url + "]:");
        return selectedAdapter;
    }
}

