/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db.schema;

import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.core.helper.CollectorsHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class Relation
extends SchemaItem {
    private Map<String, Field> fields = new LinkedHashMap<String, Field>();
    private Map<String, Integer> fieldNameToIndex = new LinkedHashMap<String, Integer>();
    private List<View> dependentViews = new LinkedList<View>();

    public Relation(String name) {
        super(name);
    }

    @Nullable
    public Field getField(String name) {
        return this.fields.get(name);
    }

    public int getFieldIndex(Field field) {
        return this.fieldNameToIndex.get(field.getName());
    }

    public Collection<Field> getFields() {
        return this.fields.values();
    }

    public void setFields(Collection<Field> fields) {
        fields.forEach(field -> field.setContainer(this));
        this.fields = fields.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        this.fieldNameToIndex = new HashMap<String, Integer>(fields.size());
        fields.stream().map(SchemaItem::getName).forEach(name -> this.fieldNameToIndex.put((String)name, this.fieldNameToIndex.size()));
    }

    public Collection<View> getDependentViews() {
        return this.dependentViews;
    }

    public void addDependentView(View view) {
        this.dependentViews.add(view);
    }
}

