/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db;

import ch.ergon.adam.core.db.interfaces.MigrationStrategy;
import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.schema.Constraint;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStrategyWrapper
implements MigrationStrategy {
    private final Logger logger;
    private final MigrationStrategy wrappedStrategy;

    public LoggingStrategyWrapper(MigrationStrategy wrappedStrategy) {
        this.wrappedStrategy = wrappedStrategy;
        this.logger = LoggerFactory.getLogger(wrappedStrategy.getClass());
    }

    @Override
    public void tableAdded(Table newTable) {
        this.logger.info("Table [{}] added", (Object)newTable.getName());
        this.wrappedStrategy.tableAdded(newTable);
    }

    @Override
    public void tableRenamed(Table oldTable, Table newTable) {
        this.logger.info("Table [{}] renamed to [{}]", (Object)oldTable.getName(), (Object)newTable.getName());
        this.wrappedStrategy.tableRenamed(oldTable, newTable);
    }

    @Override
    public void tableRemoved(Table oldTable) {
        this.logger.info("Table [{}] removed", (Object)oldTable.getName());
        this.wrappedStrategy.tableRemoved(oldTable);
    }

    @Override
    public void fieldAdded(Field newField) {
        this.logger.info("Field [{}] added to table [{}]", (Object)newField.getName(), (Object)newField.getTable().getName());
        this.wrappedStrategy.fieldAdded(newField);
    }

    @Override
    public void fieldRemoved(Field oldField) {
        this.logger.info("Field [{}] removed from table [{}]", (Object)oldField.getName(), (Object)oldField.getTable().getName());
        this.wrappedStrategy.fieldRemoved(oldField);
    }

    @Override
    public void fieldRenamed(Field oldField, Field newField) {
        this.logger.info("Field [{}] renamed to [{}] on table [{}]", new Object[]{oldField.getName(), newField.getName(), newField.getTable().getName()});
        this.wrappedStrategy.fieldRenamed(oldField, newField);
    }

    @Override
    public void fieldIndexChange(Field oldField, Field newField) {
        this.logger.info("Field [{}] index changed from [{}] to [{}] on table [{}]", new Object[]{newField.getName(), oldField.getIndex(), newField.getIndex(), newField.getTable().getName()});
        this.wrappedStrategy.fieldIndexChange(oldField, newField);
    }

    @Override
    public void fileTypeChanged(Field oldField, Field newField) {
        this.logger.info("Field [{}] type changed from [{}] to [{}] on table [{}]", new Object[]{newField.getName(), oldField.getTypeDescription(), newField.getTypeDescription(), newField.getTable().getName()});
        this.wrappedStrategy.fileTypeChanged(oldField, newField);
    }

    @Override
    public void fieldDefaultChanged(Field oldField, Field newField) {
        this.logger.info("Field [{}] default changed from [{}] to [{}] on table [{}]", new Object[]{newField.getName(), oldField.getDefaultValue(), newField.getDefaultValue(), newField.getTable().getName()});
        this.wrappedStrategy.fieldDefaultChanged(oldField, newField);
    }

    @Override
    public void indexAdded(Index newIndex) {
        this.logger.info("Index [{}] added", (Object)newIndex.getName());
        this.wrappedStrategy.indexAdded(newIndex);
    }

    @Override
    public void indexUpdated(Index oldIndex, Index newIndex) {
        this.logger.info("Index [{}] updated", (Object)newIndex.getName());
        this.wrappedStrategy.indexUpdated(oldIndex, newIndex);
    }

    @Override
    public void indexRemoved(Index oldIndex) {
        this.logger.info("Index [{}] removed", (Object)oldIndex.getName());
        this.wrappedStrategy.indexRemoved(oldIndex);
    }

    @Override
    public void foreignKeyAdded(ForeignKey newForeignKey) {
        this.logger.info("FK [{}] added", (Object)newForeignKey.getName());
        this.wrappedStrategy.foreignKeyAdded(newForeignKey);
    }

    @Override
    public void foreignKeyUpdated(ForeignKey oldForeignKey, ForeignKey newForeignKey) {
        this.logger.info("FK [{}] updated", (Object)newForeignKey.getName());
        this.wrappedStrategy.foreignKeyUpdated(oldForeignKey, newForeignKey);
    }

    @Override
    public void foreignKeyRemoved(ForeignKey oldForeignKey) {
        this.logger.info("FK [{}] removed", (Object)oldForeignKey.getName());
        this.wrappedStrategy.foreignKeyRemoved(oldForeignKey);
    }

    @Override
    public void viewAdded(View newView) {
        this.logger.info("View [{}] added", (Object)newView.getName());
        this.wrappedStrategy.viewAdded(newView);
    }

    @Override
    public void viewRemoved(View oldView) {
        this.logger.info("View [{}] removed", (Object)oldView.getName());
        this.wrappedStrategy.viewRemoved(oldView);
    }

    @Override
    public void viewUpdated(View oldView, View newView) {
        this.logger.info("View [{}] updated", (Object)newView.getName());
        this.wrappedStrategy.viewUpdated(oldView, newView);
    }

    @Override
    public void apply(SchemaSink sink) {
        this.logger.info("Apply schema changes");
        this.wrappedStrategy.apply(sink);
    }

    @Override
    public void setSourceSchema(Schema sourceSchema) {
        this.wrappedStrategy.setSourceSchema(sourceSchema);
    }

    @Override
    public void setTargetSchema(Schema targetSchema) {
        this.wrappedStrategy.setTargetSchema(targetSchema);
    }

    @Override
    public void enumAdded(DbEnum newEnum) {
        this.logger.info("Enum [{}] added", (Object)newEnum.getName());
        this.wrappedStrategy.enumAdded(newEnum);
    }

    @Override
    public void enumRemoved(DbEnum oldEnum) {
        this.logger.info("Enum [{}] removed", (Object)oldEnum.getName());
        this.wrappedStrategy.enumRemoved(oldEnum);
    }

    @Override
    public void enumUpdated(DbEnum oldEnum, DbEnum newEnum) {
        this.logger.info("Enum [{}] updated", (Object)newEnum.getName());
        this.wrappedStrategy.enumUpdated(oldEnum, newEnum);
    }

    @Override
    public void constraintAdded(Constraint newConstraint) {
        this.logger.info("Constraint [{}] added on table [{}]", (Object)newConstraint.getName(), (Object)newConstraint.getTable().getName());
        this.wrappedStrategy.constraintAdded(newConstraint);
    }

    @Override
    public void constraintRemoved(Constraint oldConstraint) {
        this.logger.info("Constraint [{}] removed from table [{}]", (Object)oldConstraint.getName(), (Object)oldConstraint.getTable().getName());
        this.wrappedStrategy.constraintRemoved(oldConstraint);
    }

    @Override
    public void constraintUpdated(Constraint oldConstraint, Constraint newConstraint) {
        this.logger.info("Constraint [{}] updated on table [{}]", (Object)newConstraint.getName(), (Object)newConstraint.getTable().getName());
        this.wrappedStrategy.constraintUpdated(oldConstraint, newConstraint);
    }

    @Override
    public void sequenceAdded(Sequence sequence) {
        this.logger.info("Sequence [{}] added", (Object)sequence.getName());
        this.wrappedStrategy.sequenceAdded(sequence);
    }

    @Override
    public void sequenceRemoved(Sequence sequence) {
        this.logger.info("Sequence [{}] removed", (Object)sequence.getName());
        this.wrappedStrategy.sequenceRemoved(sequence);
    }

    @Override
    public void sequenceUpdated(Sequence sourceSequence, Sequence targetSequence) {
        this.logger.info("Sequence [{}] updated", (Object)targetSequence.getName());
        this.wrappedStrategy.sequenceUpdated(sourceSequence, targetSequence);
    }
}

