/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db.schema;

import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.Relation;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Table;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class Field
extends SchemaItem {
    private Relation container;
    private DataType dataType;
    private DbEnum dbEnum;
    private boolean isArray;
    private Integer length;
    private Integer precision;
    private Integer scale;
    private String defaultValue;
    private String sqlForNew;
    private boolean nullable;
    private boolean sequence;
    private final Set<Index> referencingIndexes = new LinkedHashSet<Index>();

    public Field(String name) {
        super(name);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getIndex() {
        return this.getContainer().getFieldIndex(this);
    }

    public void addReferencingIndex(Index index) {
        this.referencingIndexes.add(index);
    }

    public Collection<Index> getReferencingIndexes() {
        return this.referencingIndexes;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setContainer(Relation container) {
        this.container = container;
    }

    public Relation getContainer() {
        return this.container;
    }

    public Table getTable() {
        return (Table)this.container;
    }

    public DbEnum getDbEnum() {
        return this.dbEnum;
    }

    public void setDbEnum(@Nonnull DbEnum dbEnum) {
        this.dbEnum = dbEnum;
        dbEnum.addReferencingField(this);
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean array) {
        this.isArray = array;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public void setSequence(boolean sequence) {
        this.sequence = sequence;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public String getSqlForNew() {
        return this.sqlForNew;
    }

    public void setSqlForNew(String sqlForNew) {
        this.sqlForNew = sqlForNew;
    }

    public String getTypeDescription() {
        String typeDescription = this.getDataType().name();
        if (this.getDataType() == DataType.ENUM) {
            typeDescription = this.getDbEnum().getName();
        }
        if (this.length != null) {
            typeDescription = typeDescription + "(" + this.length + ")";
        }
        if (this.precision != null) {
            typeDescription = typeDescription + "(" + this.precision;
            if (this.scale != null) {
                typeDescription = typeDescription + "," + this.scale;
            }
            typeDescription = typeDescription + ")";
        }
        if (this.isArray()) {
            typeDescription = typeDescription + "[]";
        }
        if (!this.isNullable()) {
            typeDescription = typeDescription + " not";
        }
        typeDescription = typeDescription + " null";
        return typeDescription;
    }
}

