/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.helper;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;

public class FileHelper {
    public static void deleteFolderRecursively(Path folder) throws IOException {
        Files.walk(folder, new FileVisitOption[0]).map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
    }

    public static Path getRepoBase() {
        Path gitFolder;
        for (gitFolder = Paths.get(System.getProperty("user.dir"), new String[0]); gitFolder != null && !FileHelper.isGitRepo(gitFolder); gitFolder = gitFolder.getParent()) {
        }
        return gitFolder;
    }

    private static boolean isGitRepo(Path currentFolder) {
        return Arrays.stream(currentFolder.toFile().listFiles()).anyMatch(file -> file.getName().equals(".git"));
    }
}

