/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.prepost;

import ch.ergon.adam.core.helper.CollectorsHelper;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class GitVersionTree {
    Map<String, Collection<String>> gitCommitsWithAncestor = new HashMap<String, Collection<String>>();

    public GitVersionTree(Path path) throws IOException {
        this.loadFromGitRepo(path.toFile());
    }

    public GitVersionTree(InputStream is) throws IOException {
        this.loadFromHistoryFile(is);
    }

    private void loadFromHistoryFile(InputStream is) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));){
            br.lines().forEach(line -> {
                String[] parts = line.split(" ", 2);
                Object[] parents = parts.length == 1 || parts[1].isEmpty() ? new String[]{} : parts[1].split(" ");
                this.gitCommitsWithAncestor.put(parts[0], Lists.newArrayList((Object[])parents));
            });
        }
    }

    private void loadFromGitRepo(File gitRepo) throws IOException {
        try {
            Git git = Git.open((File)gitRepo);
            git.log().all().call().forEach(commit -> {
                String id = commit.getId().name();
                if (!this.gitCommitsWithAncestor.containsKey(id)) {
                    List parents = Arrays.stream(commit.getParents()).map(parentCommit -> parentCommit.getId().name()).collect(Collectors.toList());
                    this.gitCommitsWithAncestor.put(id, parents);
                }
            });
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    public void writeToFile(OutputStream outputStream) {
        this.gitCommitsWithAncestor.entrySet().forEach(entry -> {
            String parents = ((Collection)entry.getValue()).stream().collect(Collectors.joining(" "));
            try {
                outputStream.write(String.format("%s %s\n", entry.getKey(), parents).getBytes(Charsets.UTF_8));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public List<String> getVersionsBetween(String fromVersion, String toVersion) {
        Collection<String> oldCommits = this.getCommitsContainedIn(fromVersion);
        Collection<String> newCommits = this.getCommitsContainedIn(toVersion);
        newCommits.removeAll(oldCommits);
        List<String> sortedCommits = this.sortCommit(newCommits);
        return sortedCommits;
    }

    private Collection<String> getCommitsContainedIn(String commitId) {
        HashSet<String> commits = new HashSet<String>();
        LinkedList<String> commitsToFollow = new LinkedList<String>();
        commitsToFollow.add(commitId);
        while (!commitsToFollow.isEmpty()) {
            String commit = (String)commitsToFollow.poll();
            if (commits.contains(commit)) continue;
            commits.add(commit);
            commitsToFollow.addAll(this.gitCommitsWithAncestor.get(commit));
        }
        return commits;
    }

    private List<String> sortCommit(Collection<String> commits) {
        Map commitsWithInDegrees = commits.stream().collect(CollectorsHelper.toLinkedMap(Function.identity(), commit -> 0));
        commits.stream().flatMap(commit -> this.gitCommitsWithAncestor.get(commit).stream()).filter(commitsWithInDegrees::containsKey).forEach(ancestor -> commitsWithInDegrees.replace(ancestor, (Integer)commitsWithInDegrees.get(ancestor) + 1));
        ArrayList<String> orderedCommits = new ArrayList<String>();
        while (!commitsWithInDegrees.isEmpty()) {
            List<String> commitsWithZeroInDegree = commitsWithInDegrees.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 0).map(Map.Entry::getKey).collect(Collectors.toList());
            if (commitsWithZeroInDegree.isEmpty()) {
                throw new RuntimeException("No commits found with zero in degree.");
            }
            commitsWithZeroInDegree.forEach(commitWithZeroInDegree -> {
                commitsWithInDegrees.remove(commitWithZeroInDegree);
                this.gitCommitsWithAncestor.get(commitWithZeroInDegree).forEach(ancestor -> {
                    if (commitsWithInDegrees.containsKey(ancestor)) {
                        commitsWithInDegrees.replace(ancestor, (Integer)commitsWithInDegrees.get(ancestor) - 1);
                    }
                });
            });
            orderedCommits.addAll(commitsWithZeroInDegree);
        }
        return Lists.reverse(orderedCommits);
    }

    public boolean isKnownVersion(String commitId) {
        return this.gitCommitsWithAncestor.containsKey(commitId);
    }

    public boolean isAncestor(String ancestorCommit, String referenceCommit) {
        return this.getCommitsContainedIn(referenceCommit).contains(ancestorCommit);
    }
}

