/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core;

import ch.ergon.adam.core.MigrationConfiguration;
import ch.ergon.adam.core.db.SchemaMigrator;
import ch.ergon.adam.core.db.SourceAndSinkFactory;
import ch.ergon.adam.core.db.interfaces.SqlExecutor;
import ch.ergon.adam.core.filetree.ClasspathTraverser;
import ch.ergon.adam.core.filetree.DirectoryTraverser;
import ch.ergon.adam.core.filetree.FileTreeTraverser;
import ch.ergon.adam.core.filetree.TraverserFile;
import ch.ergon.adam.core.prepost.GitVersionTree;
import ch.ergon.adam.core.prepost.MigrationScriptProvider;
import ch.ergon.adam.core.prepost.MigrationStep;
import ch.ergon.adam.core.prepost.MigrationStepExecutor;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Adam {
    private static final Logger logger = LoggerFactory.getLogger(Adam.class);
    public static final String TARGET_VERSION_FILE_NAME = "target_version";
    public static final String HISTORY_FILE_NAME = "git_history";
    public static final String DEFAULT_ADAM_PACKAGE = "adam/";
    public static final String DEFAULT_SCHEMA_PACKAGE = "adam/schema";
    public static final String DEFAULT_SCRIPTS_PACKAGE = "adam/scripts";
    public static final String DEFAULT_ADAM_EXPORT_PACKAGE = "adam/export";
    public static final String DEFAULT_MAIN_RESOURCE_PATH = "src/main/resources/";
    private final String referenceUrl;
    private final String targetUrl;
    private final String targetVersion;
    private final GitVersionTree versionTree;
    private final FileTreeTraverser migrationScriptTraverser;
    private boolean allowUnknownDBVersion = false;
    private boolean allowNonForwardMigration = false;
    private boolean migrateSameVersion = false;
    private Collection<String> includes;
    private Collection<String> excludes;

    public static Adam usingGitRepo(String referenceSchemaUrl, String targetUrl, String targetVersion, File migrationScriptPath, File gitRepo) throws IOException {
        return new Adam(referenceSchemaUrl, targetUrl, targetVersion, new GitVersionTree(gitRepo.toPath()), new DirectoryTraverser(migrationScriptPath.toPath()));
    }

    public static Adam usingExportDirectory(String targetUrl, String referenceSchemaProtocol, Path schemaSourcePath, Path exportPath) throws IOException {
        String referenceSchemaUrl = referenceSchemaProtocol + "://" + String.valueOf(schemaSourcePath);
        return new Adam(referenceSchemaUrl, targetUrl, Adam.readTargetVersionFromFile(exportPath), Adam.getGitVersionTreeFromFile(exportPath), new DirectoryTraverser(exportPath.resolve("scripts")));
    }

    public static Adam usingClasspath(String targetUrl, String referenceSchemaProtocol) throws IOException {
        String schemaSourcePathPackage = System.getProperty("adam.schema.package", DEFAULT_SCHEMA_PACKAGE);
        String exportPackage = System.getProperty("adam.export.package", DEFAULT_ADAM_EXPORT_PACKAGE);
        return Adam.usingClasspath(targetUrl, referenceSchemaProtocol, schemaSourcePathPackage, exportPackage);
    }

    public static Adam usingClasspath(String targetUrl, String referenceSchemaProtocol, String schemaSourcePackage, String exportPackage) throws IOException {
        String referenceSchemaUrl = referenceSchemaProtocol + "-classpath://" + schemaSourcePackage;
        return new Adam(referenceSchemaUrl, targetUrl, Adam.readTargetVersionFromClasspath(exportPackage), Adam.getGitVersionTreeFromClasspath(exportPackage), new ClasspathTraverser(exportPackage + "/scripts"));
    }

    private static GitVersionTree getGitVersionTreeFromFile(Path exportPath) throws IOException {
        Path historyFile = exportPath.resolve(HISTORY_FILE_NAME);
        try (FileInputStream is = new FileInputStream(historyFile.toFile());){
            GitVersionTree gitVersionTree = new GitVersionTree(is);
            return gitVersionTree;
        }
    }

    private static String readTargetVersionFromFile(Path exportPath) throws IOException {
        Path targetVersionFile = exportPath.resolve(TARGET_VERSION_FILE_NAME);
        return Files.readAllLines(targetVersionFile).get(0);
    }

    private static GitVersionTree getGitVersionTreeFromClasspath(String exportPackage) throws IOException {
        String historyFile = exportPackage + "/git_history";
        try (InputStream is = ClassLoader.getSystemResourceAsStream(historyFile);){
            GitVersionTree gitVersionTree = new GitVersionTree(is);
            return gitVersionTree;
        }
    }

    /*
     * Exception decompiling
     */
    private static String readTargetVersionFromClasspath(String exportPackage) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Adam(String referenceUrl, String targetUrl, String targetVersion, GitVersionTree versionTree, FileTreeTraverser migrationScriptTraverser) {
        this.referenceUrl = referenceUrl;
        this.targetUrl = targetUrl;
        this.targetVersion = targetVersion;
        this.versionTree = versionTree;
        this.migrationScriptTraverser = migrationScriptTraverser;
        if (!versionTree.isKnownVersion(targetVersion)) {
            throw new RuntimeException("Target version [" + targetVersion + "] is unknown.");
        }
    }

    public void execute() throws IOException {
        logger.info("Execute migration: referenceUrl '{}', targetUrl '{}', targetVersion '{}'", new Object[]{this.referenceUrl, this.targetUrl, this.targetVersion});
        this.ensureSchemaVersionTable(this.targetUrl);
        try (SqlExecutor targetExecutor = SourceAndSinkFactory.getInstance().getSqlExecutor(this.targetUrl);){
            boolean isDbInit;
            this.ensureNoInProgressMigrations(targetExecutor);
            String fromVersion = this.getDbSchemaVersion(targetExecutor);
            boolean bl = isDbInit = fromVersion == null;
            if (isDbInit) {
                logger.info("Doing initial db migration to '{}'. Executing init instead of pre-/post-migration scripts", (Object)this.targetVersion);
            } else {
                logger.info("Doing db migration from '{}' to '{}'.", (Object)fromVersion, (Object)this.targetVersion);
            }
            if (!isDbInit && fromVersion.equals(this.targetVersion) && !this.migrateSameVersion) {
                logger.info("Skip migration since source- and targetVersion are the same.");
                return;
            }
            try {
                boolean unknownVersion;
                this.createSchemaVersionEntry(targetExecutor, fromVersion, this.targetVersion);
                boolean bl2 = unknownVersion = !isDbInit && !this.versionTree.isKnownVersion(fromVersion);
                if (unknownVersion) {
                    if (!this.allowUnknownDBVersion) {
                        throw new RuntimeException("Current db version [" + fromVersion + "] is unknown.");
                    }
                    logger.warn("The current db schema version [{}] is unknown. Migration will be executed WITHOUT pre-/post-migration.", (Object)fromVersion);
                } else if (fromVersion != null && !this.versionTree.isAncestor(fromVersion, this.targetVersion)) {
                    if (!this.allowNonForwardMigration) {
                        throw new RuntimeException("DB version [" + fromVersion + "] is not an ancestor of target version [" + this.targetVersion + "]");
                    }
                    logger.warn("DB version [" + fromVersion + "] is not an ancestor of target version [" + this.targetVersion + "]");
                }
                if (!unknownVersion && !isDbInit) {
                    List<String> versions = this.versionTree.getVersionsBetween(fromVersion, this.targetVersion);
                    MigrationScriptProvider migrationScriptProvider = new MigrationScriptProvider(this.migrationScriptTraverser, versions);
                    this.logExecutionOrder(migrationScriptProvider);
                    MigrationStepExecutor executor = new MigrationStepExecutor(migrationScriptProvider, targetExecutor);
                    executor.executeStep(MigrationStep.PREMIGRATION_ALWAYS);
                    executor.executeStep(MigrationStep.PREMIGRATION_ONCE);
                    SchemaMigrator.migrate(this.referenceUrl, this.targetUrl, this.getMigrationConfig());
                    executor.executeStep(MigrationStep.POSTMIGRATION_ONCE);
                    executor.executeStep(MigrationStep.POSTMIGRATION_ALWAYS);
                } else {
                    MigrationScriptProvider migrationScriptProvider = new MigrationScriptProvider(this.migrationScriptTraverser);
                    MigrationStepExecutor executor = new MigrationStepExecutor(migrationScriptProvider, targetExecutor);
                    if (isDbInit) {
                        executor.executeStep(MigrationStep.PREMIGRATION_INIT);
                    }
                    SchemaMigrator.migrate(this.referenceUrl, this.targetUrl, this.getMigrationConfig());
                    if (isDbInit) {
                        executor.executeStep(MigrationStep.POSTMIGRATION_INIT);
                    }
                }
                this.completeSchemaVersionEntry(targetExecutor);
            }
            catch (Exception e) {
                targetExecutor.rollback();
                throw e;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MigrationConfiguration getMigrationConfig() {
        MigrationConfiguration migrationConfiguration = new MigrationConfiguration();
        HashSet excludeList = Sets.newHashSet((Object[])new String[]{"db_schema_version"});
        if (this.excludes != null) {
            excludeList.addAll(this.excludes);
        }
        migrationConfiguration.setObjectNameExcludeList(excludeList);
        migrationConfiguration.setObjectNameIncludeList(this.includes);
        return migrationConfiguration;
    }

    private void logExecutionOrder(MigrationScriptProvider migrationScriptProvider) {
        logger.info("The following scripts will be executed in given order:");
        this.logExecutionOrderForStep(migrationScriptProvider, MigrationStep.PREMIGRATION_ALWAYS);
        this.logExecutionOrderForStep(migrationScriptProvider, MigrationStep.PREMIGRATION_ONCE);
        logger.info("Automated schema migration.");
        this.logExecutionOrderForStep(migrationScriptProvider, MigrationStep.POSTMIGRATION_ONCE);
        this.logExecutionOrderForStep(migrationScriptProvider, MigrationStep.POSTMIGRATION_ALWAYS);
    }

    private void logExecutionOrderForStep(MigrationScriptProvider migrationScriptProvider, MigrationStep step) {
        List<TraverserFile> scripts = migrationScriptProvider.getMigrationScripts(step);
        if (scripts.isEmpty()) {
            return;
        }
        logger.info("Step {}:", (Object)step.name());
        scripts.forEach(script -> logger.info(" - {}", (Object)script.getName()));
    }

    private void ensureSchemaVersionTable(String targetUrl) {
        String schemaPath = "dbschemaversion://dummy";
        MigrationConfiguration migrationConfiguration = new MigrationConfiguration();
        migrationConfiguration.setObjectNameExcludeList(null);
        migrationConfiguration.setObjectNameIncludeList(Lists.newArrayList((Object[])new String[]{"db_schema_version"}));
        SchemaMigrator.migrate(schemaPath, targetUrl, migrationConfiguration);
    }

    private void ensureNoInProgressMigrations(SqlExecutor sqlExecutor) {
        Object result = sqlExecutor.queryResult(String.format("SELECT COUNT(1) FROM \"%s\" WHERE \"execution_completed_at\" IS NULL", "db_schema_version"), new Object[0]);
        if (Integer.parseInt(result.toString()) != 0) {
            throw new RuntimeException("There is an unfinished migration in [db_schema_version]");
        }
    }

    private String getDbSchemaVersion(SqlExecutor sqlExecutor) {
        Object result = sqlExecutor.queryResult(String.format("SELECT \"target_version\" FROM \"%s\" ORDER BY \"execution_started_at\" DESC", "db_schema_version"), new Object[0]);
        return result == null ? null : result.toString();
    }

    private void createSchemaVersionEntry(SqlExecutor sqlExecutor, String fromVersion, String toVersion) {
        sqlExecutor.queryResult(String.format("INSERT INTO \"%s\" (\"execution_started_at\", \"source_version\", \"target_version\") VALUES (CURRENT_TIMESTAMP, ?, ?)", "db_schema_version"), fromVersion, toVersion);
    }

    private void completeSchemaVersionEntry(SqlExecutor sqlExecutor) {
        sqlExecutor.queryResult(String.format("UPDATE \"%s\" SET \"execution_completed_at\" = CURRENT_TIMESTAMP WHERE \"execution_completed_at\" IS NULL", "db_schema_version"), new Object[0]);
    }

    public void setAllowUnknownDBVersion(boolean allowUnknownDBVersion) {
        this.allowUnknownDBVersion = allowUnknownDBVersion;
    }

    public boolean isAllowUnknownDBVersion() {
        return this.allowUnknownDBVersion;
    }

    public boolean isMigrateSameVersion() {
        return this.migrateSameVersion;
    }

    public void setMigrateSameVersion(boolean migrateSameVersion) {
        this.migrateSameVersion = migrateSameVersion;
    }

    public boolean isAllowNonForwardMigration() {
        return this.allowNonForwardMigration;
    }

    public void setAllowNonForwardMigration(boolean allowNonForwardMigration) {
        this.allowNonForwardMigration = allowNonForwardMigration;
    }

    public void setIncludes(Collection<String> includes) {
        this.includes = includes;
    }

    public void setExcludes(Collection<String> excludes) {
        this.excludes = excludes;
    }
}

