/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.filetree;

import ch.ergon.adam.core.filetree.FileTreeTraverser;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;

public class ClasspathTraverser
implements FileTreeTraverser {
    private final Reflections reflections;
    private final String path;

    public ClasspathTraverser(String path) {
        this.path = path.endsWith("/") ? path : path + "/";
        this.reflections = new Reflections(this.path, new Scanner[]{new ResourcesScanner()});
    }

    @Override
    public InputStream openFile(String fileName) {
        Set resources = this.reflections.getResources(name -> name.equals(fileName));
        if (resources.isEmpty()) {
            return null;
        }
        if (resources.size() > 1) {
            throw new RuntimeException("Found multiple resources with name [" + fileName + "].");
        }
        String filePath = (String)resources.iterator().next();
        return this.getClass().getClassLoader().getResourceAsStream(filePath);
    }

    @Override
    public List<String> getFileNames() {
        return this.reflections.getResources(name -> true).stream().map(name -> name.replaceFirst(this.path, "")).sorted().collect(Collectors.toList());
    }

    @Override
    public FileTreeTraverser cd(String subPath) {
        if (!this.getFileNames().stream().anyMatch(entry -> entry.equals(subPath) || entry.startsWith(subPath + "/"))) {
            return null;
        }
        return new ClasspathTraverser(this.path + subPath);
    }

    public String toString() {
        return "classpath:" + this.path;
    }
}

