/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.filetree;

import ch.ergon.adam.core.filetree.FileTreeTraverser;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DirectoryTraverser
implements FileTreeTraverser {
    private final File path;

    public DirectoryTraverser(Path path) {
        this.path = path.toFile();
    }

    @Override
    public InputStream openFile(String fileName) throws IOException {
        File file = new File(this.path, fileName);
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    @Override
    public List<String> getFileNames() {
        if (!this.path.exists()) {
            return Lists.newArrayList();
        }
        return Arrays.stream(this.path.listFiles()).map(File::getName).sorted().collect(Collectors.toList());
    }

    @Override
    public FileTreeTraverser cd(String subPath) {
        File subFile = new File(this.path, subPath);
        if (!subFile.exists() || !subFile.isDirectory()) {
            return null;
        }
        return new DirectoryTraverser(subFile.toPath());
    }

    public String toString() {
        return this.path.getAbsolutePath();
    }

    public File getFile(String name) {
        return new File(this.path, name);
    }
}

