/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.prepost;

import ch.ergon.adam.core.filetree.FileTreeTraverser;
import ch.ergon.adam.core.filetree.TraverserFile;
import ch.ergon.adam.core.prepost.MigrationStep;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationScriptProvider {
    private static final String VERSION_PREFIX = "-- commit:";
    private static final String SQL = ".sql";
    private static final Logger logger = LoggerFactory.getLogger(MigrationScriptProvider.class);
    private final FileTreeTraverser migrationScriptDirectoryTraverser;
    private final Path gitRepo;
    private final List<String> versions;
    private Git git;

    public MigrationScriptProvider(FileTreeTraverser migrationScriptDirectoryTraverser) {
        this.migrationScriptDirectoryTraverser = migrationScriptDirectoryTraverser;
        this.versions = null;
        this.gitRepo = null;
    }

    public MigrationScriptProvider(FileTreeTraverser migrationScriptDirectoryTraverser, Path gitRepo) {
        this.migrationScriptDirectoryTraverser = migrationScriptDirectoryTraverser;
        this.gitRepo = gitRepo;
        this.versions = null;
    }

    public MigrationScriptProvider(FileTreeTraverser migrationScriptDirectoryTraverser, List<String> versions) {
        this.migrationScriptDirectoryTraverser = migrationScriptDirectoryTraverser;
        this.versions = versions;
        this.gitRepo = null;
    }

    public MigrationScriptProvider(FileTreeTraverser migrationScriptDirectoryTraverser, Path gitRepo, List<String> versions) {
        this.migrationScriptDirectoryTraverser = migrationScriptDirectoryTraverser;
        this.gitRepo = gitRepo;
        this.versions = versions;
    }

    public List<TraverserFile> getMigrationScripts(MigrationStep step) {
        FileTreeTraverser stepTraverser = this.getTraverserForMigrationStepScripts(step);
        if (this.stepRequiresVersion(step)) {
            List<ScriptWithVersion> scripts = this.loadScriptsWithVersion(stepTraverser);
            return scripts.stream().filter(scriptWithVersion -> this.versions.contains(scriptWithVersion.getVersion())).sorted(Comparator.comparing(scriptWithVersion -> this.versions.indexOf(scriptWithVersion.getVersion()))).map(ScriptWithVersion::getScript).collect(Collectors.toList());
        }
        return this.listSqlFiles(stepTraverser);
    }

    public void exportMigrationScripts(File exportPath) throws IOException {
        if (this.gitRepo == null) {
            throw new IllegalStateException("Git repo is required to export migration files.");
        }
        for (MigrationStep step : MigrationStep.values()) {
            FileTreeTraverser traverser = this.getTraverserForMigrationStepScripts(step);
            File stepExportPath = new File(exportPath, step.name());
            if (!stepExportPath.exists()) {
                stepExportPath.mkdirs();
            }
            if (this.stepRequiresVersion(step)) {
                List<ScriptWithVersion> scriptsWithVersion = this.loadScriptsWithVersion(traverser);
                for (ScriptWithVersion scriptWithVersion : scriptsWithVersion) {
                    File exportFile = new File(stepExportPath, scriptWithVersion.version + "_" + scriptWithVersion.script.getName());
                    Files.copy((File)scriptWithVersion.script.getFile(), (File)exportFile);
                }
                continue;
            }
            for (TraverserFile script : this.listSqlFiles(traverser)) {
                File exportFile = new File(stepExportPath, script.getName());
                Files.copy((File)script.getFile(), (File)exportFile);
            }
        }
    }

    private FileTreeTraverser getTraverserForMigrationStepScripts(MigrationStep step) {
        return this.migrationScriptDirectoryTraverser.cd(step.name());
    }

    private List<TraverserFile> listSqlFiles(FileTreeTraverser traverser) {
        if (traverser == null) {
            return Lists.newArrayList();
        }
        return traverser.getFiles().stream().filter(file -> file.getName().toLowerCase().endsWith(SQL)).sorted(Comparator.comparing(TraverserFile::getName)).collect(Collectors.toList());
    }

    private boolean stepRequiresVersion(MigrationStep step) {
        return step == MigrationStep.POSTMIGRATION_ONCE || step == MigrationStep.PREMIGRATION_ONCE;
    }

    private List<ScriptWithVersion> loadScriptsWithVersion(FileTreeTraverser traverser) {
        return this.listSqlFiles(traverser).stream().map(file -> new ScriptWithVersion(this, this.getScriptVersion((TraverserFile)file), (TraverserFile)file)).collect(Collectors.toList());
    }

    private String getScriptVersion(TraverserFile script) {
        String version = this.getScriptVersionFromFile(script);
        if (version == null && this.gitRepo != null) {
            version = this.getScriptVersionFromGit(script);
        }
        if (version == null) {
            version = this.getScriptVersionFromFileName(script);
        }
        if (version == null) {
            throw new RuntimeException("Could not get commit for script file [" + script.getName() + "]");
        }
        return version;
    }

    private Git getGit() throws IOException {
        if (this.git == null) {
            this.git = Git.open((File)this.gitRepo.toFile());
        }
        return this.git;
    }

    private String getScriptVersionFromGit(TraverserFile script) {
        File scriptFile = script.getFile();
        if (scriptFile == null) {
            throw new RuntimeException("Could net get script file for [" + script.getName() + "]");
        }
        try {
            Git git = this.getGit();
            File relativeScriptPath = this.gitRepo.relativize(scriptFile.getAbsoluteFile().toPath()).toFile();
            RevCommit firstCommit = null;
            Iterator iterator = git.log().addPath(relativeScriptPath.getPath().replaceAll("\\\\", "/")).call().iterator();
            while (iterator.hasNext()) {
                RevCommit revCommit;
                firstCommit = revCommit = (RevCommit)iterator.next();
            }
            if (firstCommit == null) {
                logger.warn("Could not get script version for file [" + String.valueOf(relativeScriptPath) + "].");
                return null;
            }
            return firstCommit.getId().name();
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private String getScriptVersionFromFileName(TraverserFile script) {
        String fileName = script.getName();
        int indexOfDash = fileName.indexOf("_");
        if (indexOfDash <= 0) {
            return null;
        }
        return fileName.substring(0, indexOfDash);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getScriptVersionFromFile(TraverserFile script) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(script.getInputStream()));){
            String firstLine = reader.readLine();
            if (firstLine != null && firstLine.startsWith(VERSION_PREFIX)) {
                String string = firstLine.replaceFirst(VERSION_PREFIX, "").trim();
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class ScriptWithVersion {
        private final String version;
        private final TraverserFile script;

        private ScriptWithVersion(MigrationScriptProvider migrationScriptProvider, String version, TraverserFile script) {
            this.version = version;
            this.script = script;
        }

        public TraverserFile getScript() {
            return this.script;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

