/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db.schema;

import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Relation;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.core.helper.CollectorsHelper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Schema {
    private Map<String, Table> tables = new LinkedHashMap<String, Table>();
    private Map<String, View> views = new LinkedHashMap<String, View>();
    private Map<String, DbEnum> enums = new LinkedHashMap<String, DbEnum>();
    private Map<String, Sequence> sequences = new LinkedHashMap<String, Sequence>();

    public Table getTable(String name) {
        return this.tables.get(name);
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public void setTables(Collection<Table> tables) {
        this.tables = tables.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
    }

    public View getView(String name) {
        return this.views.get(name);
    }

    public Collection<View> getViews() {
        return this.views.values();
    }

    public void setViews(Collection<View> views) {
        this.views = views.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
    }

    @Nullable
    public DbEnum getEnum(String name) {
        return this.enums.get(name);
    }

    public Collection<DbEnum> getEnums() {
        return this.enums.values();
    }

    public void setEnums(Collection<DbEnum> enums) {
        this.enums = enums.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
    }

    public Sequence getSequence(String name) {
        return this.sequences.get(name);
    }

    public Collection<Sequence> getSequences() {
        return this.sequences.values();
    }

    public void setSequences(Collection<Sequence> sequences) {
        this.sequences = sequences.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
    }

    public Relation getRelation(String name) {
        if (this.views.containsKey(name)) {
            return this.views.get(name);
        }
        return this.tables.get(name);
    }
}

