/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.filetree;

import ch.ergon.adam.core.filetree.FileTreeTraverser;
import ch.ergon.adam.core.reflection.ReflectionHelper;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;

public class ClasspathTraverser
implements FileTreeTraverser {
    private final String path;

    public ClasspathTraverser(String path) {
        this.path = path.endsWith("/") ? path : path + "/";
    }

    @Override
    public InputStream openFile(String fileName) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(this.path + fileName);
    }

    @Override
    public List<String> getFileNames() {
        return ReflectionHelper.findAllRessourcesForPath(this.path).stream().map(name -> name.replaceFirst(this.path, "")).sorted().collect(Collectors.toList());
    }

    @Override
    public FileTreeTraverser cd(String subPath) {
        if (!this.getFileNames().stream().anyMatch(entry -> entry.equals(subPath) || entry.startsWith(subPath + "/"))) {
            return null;
        }
        return new ClasspathTraverser(this.path + subPath);
    }

    public String toString() {
        return "classpath:" + this.path;
    }
}

