/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db.schema;

import ch.ergon.adam.core.db.schema.Constraint;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.Relation;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.TableItem;
import ch.ergon.adam.core.helper.CollectorsHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Table
extends Relation {
    private Map<String, Index> indexes = new LinkedHashMap<String, Index>();
    private Map<String, ForeignKey> foreignKeys = new LinkedHashMap<String, ForeignKey>();
    private Map<String, Constraint> constraints = new LinkedHashMap<String, Constraint>();
    private String previousName;

    public Table(String name) {
        super(name);
    }

    @Nullable
    public Index getIndex(String name) {
        return this.indexes.get(name);
    }

    public Collection<Index> getIndexes() {
        return this.indexes.values();
    }

    public void setIndexes(List<Index> indexes) {
        this.setTable(indexes);
        this.indexes = indexes.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
    }

    public Collection<ForeignKey> getForeignKeys() {
        return this.foreignKeys.values();
    }

    public void setForeignKeys(List<ForeignKey> foreignKeys) {
        this.setTable(foreignKeys);
        this.foreignKeys = foreignKeys.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
    }

    @Nullable
    public Constraint getConstraint(String name) {
        return this.constraints.get(name);
    }

    public Collection<Constraint> getConstraints() {
        return this.constraints.values();
    }

    public void setConstraints(List<Constraint> constraints) {
        this.setTable(constraints);
        this.constraints = constraints.stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
    }

    private <T extends TableItem> void setTable(Collection<T> items) {
        items.forEach(item -> item.setTable(this));
    }

    public Index getIndex(List<Field> foreignFields) {
        CharSequence[] foreignFieldNames = CollectorsHelper.createSchemaItemNameArray(foreignFields);
        List matchingIndexes = this.indexes.values().stream().filter(arg_0 -> Table.lambda$getIndex$1((String[])foreignFieldNames, arg_0)).collect(Collectors.toList());
        if (matchingIndexes.isEmpty()) {
            throw new RuntimeException("No index with matching field order " + String.join((CharSequence)",", foreignFieldNames) + " found.");
        }
        return (Index)matchingIndexes.get(0);
    }

    public String getPreviousName() {
        return this.previousName;
    }

    public void setPreviousName(String previousName) {
        this.previousName = previousName;
    }

    private static /* synthetic */ boolean lambda$getIndex$1(String[] foreignFieldNames, Index index) {
        return Arrays.equals(foreignFieldNames, CollectorsHelper.createSchemaItemNameArray(index.getFields()));
    }
}

