/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.reflection;

import com.google.common.reflect.ClassPath;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReflectionHelper {
    public static final Map<String, Set<Class<?>>> classesByPackageCache = new HashMap();
    public static final Map<String, Set<String>> resourcesByPathCache = new HashMap<String, Set<String>>();

    private static Set<Class<?>> findAllClassesForPackage(String packageName) {
        if (!classesByPackageCache.containsKey(packageName)) {
            try {
                Set classes = ClassPath.from((ClassLoader)ReflectionHelper.class.getClassLoader()).getAllClasses().stream().filter(c -> c.getPackageName().startsWith(packageName)).map(ClassPath.ClassInfo::getName).map(ReflectionHelper::getClass).collect(Collectors.toSet());
                classesByPackageCache.put(packageName, classes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return classesByPackageCache.get(packageName);
    }

    public static Set<String> findAllRessourcesForPath(String path) {
        if (!resourcesByPathCache.containsKey(path)) {
            try {
                Set resources = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getResources().stream().filter(r -> r.getResourceName().startsWith(path)).map(ClassPath.ResourceInfo::getResourceName).collect(Collectors.toSet());
                resourcesByPathCache.put(path, resources);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resourcesByPathCache.get(path);
    }

    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Set<Class<? extends T>> findAllSubClasses(String packageName, Class<T> superClass) {
        return ReflectionHelper.findAllClassesForPackage(packageName).stream().filter(superClass::isAssignableFrom).filter(c -> !c.isInterface() && !Modifier.isAbstract(c.getModifiers())).map(c -> c).collect(Collectors.toSet());
    }
}

