/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.db;

import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.schema.Constraint;
import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSinkWrapper
implements SchemaSink {
    private final Logger logger;
    private final SchemaSink wrappedSink;

    public LoggingSinkWrapper(SchemaSink wrappedSink) {
        this.wrappedSink = wrappedSink;
        this.logger = LoggerFactory.getLogger(wrappedSink.getClass());
    }

    @Override
    public void setTargetSchema(Schema targetSchema) {
        this.wrappedSink.setTargetSchema(targetSchema);
    }

    @Override
    public void commitChanges() {
        this.logger.info("Commit schema changes.");
        this.wrappedSink.commitChanges();
    }

    @Override
    public void rollback() {
    }

    @Override
    public void dropForeignKey(ForeignKey foreignKey) {
        this.logger.info("Drop FK [{}]", (Object)foreignKey.getName());
        this.wrappedSink.dropForeignKey(foreignKey);
    }

    @Override
    public void createForeignKey(ForeignKey foreignKey) {
        this.logger.info("Create FK [{}]", (Object)foreignKey.getName());
        this.wrappedSink.createForeignKey(foreignKey);
    }

    @Override
    public void dropIndex(Index index) {
        this.logger.info("Drop index [{}]", (Object)index.getName());
        this.wrappedSink.dropIndex(index);
    }

    @Override
    public void createIndex(Index index) {
        this.logger.info("Create index [{}]", (Object)index.getName());
        this.wrappedSink.createIndex(index);
    }

    @Override
    public void addField(Field field) {
        this.logger.info("Create field [{}]", (Object)field.getName());
        this.wrappedSink.addField(field);
    }

    @Override
    public void dropField(Field field, Table table) {
        this.logger.info("Drop field [{}] from table [{}]", (Object)field.getName(), (Object)table.getName());
        this.wrappedSink.dropField(field, table);
    }

    @Override
    public void setDefault(Field field) {
        this.logger.info("Set default [{}] for field [{}] on table [{}]", new Object[]{field.getDefaultValue(), field.getName(), field.getTable().getName()});
        this.wrappedSink.setDefault(field);
    }

    @Override
    public void dropDefault(Field field) {
        this.logger.info("Drop default from field [{}] on table [{}]", (Object)field.getName(), (Object)field.getTable().getName());
        this.wrappedSink.dropDefault(field);
    }

    @Override
    public void createTable(Table table) {
        this.logger.info("Create table [{}]", (Object)table.getName());
        this.wrappedSink.createTable(table);
    }

    @Override
    public void dropTable(Table table) {
        this.logger.info("Drop table [{}]", (Object)table.getName());
        this.wrappedSink.dropTable(table);
    }

    @Override
    public void renameTable(Table oldTable, String newTableName) {
        this.logger.info("Rename table [{}] to [{}]", (Object)oldTable.getName(), (Object)newTableName);
        this.wrappedSink.renameTable(oldTable, newTableName);
    }

    @Override
    public void copyData(Table sourceTable, Table targetTable, String sourceTableName) {
        this.logger.info("Copy data from table [{}] to [{}]", (Object)sourceTableName, (Object)targetTable.getName());
        this.wrappedSink.copyData(sourceTable, targetTable, sourceTableName);
    }

    @Override
    public void createView(View view) {
        this.logger.info("Create view [{}]", (Object)view.getName());
        this.wrappedSink.createView(view);
    }

    @Override
    public void dropView(View view) {
        this.logger.info("Drop view [{}]", (Object)view.getName());
        this.wrappedSink.dropView(view);
    }

    @Override
    public void dropEnum(DbEnum dbEnum) {
        this.logger.info("Drop enum [{}]", (Object)dbEnum.getName());
        this.wrappedSink.dropEnum(dbEnum);
    }

    @Override
    public void createEnum(DbEnum dbEnum) {
        this.logger.info("Create enum [{}]", (Object)dbEnum.getName());
        this.wrappedSink.createEnum(dbEnum);
    }

    @Override
    public void changeFieldType(Field oldField, Field newField, DataType targetDataType) {
        this.logger.info("Change type of field [{}.{}] to [{}]", new Object[]{oldField.getTable().getName(), oldField.getName(), targetDataType.name()});
        this.wrappedSink.changeFieldType(oldField, newField, targetDataType);
    }

    @Override
    public void dropConstraint(Constraint constraint) {
        this.logger.info("Drop constraint [{}]", (Object)constraint.getName());
        this.wrappedSink.dropConstraint(constraint);
    }

    @Override
    public void createConstraint(Constraint constraint) {
        this.logger.info("Create constraint [{}]", (Object)constraint.getName());
        this.wrappedSink.createConstraint(constraint);
    }

    @Override
    public void dropSequence(Sequence sequence) {
        this.logger.info("Drop sequence [{}]", (Object)sequence.getName());
        this.wrappedSink.dropSequence(sequence);
    }

    @Override
    public void createSequence(Sequence sequence) {
        this.logger.info("Create sequence [{}]", (Object)sequence.getName());
        this.wrappedSink.createSequence(sequence);
    }

    @Override
    public void dropSequencesAndDefaults(Table table) {
        this.logger.info("Drop sequences and default for table [{}]", (Object)table.getName());
        this.wrappedSink.dropSequencesAndDefaults(table);
    }

    @Override
    public void adjustSequences(Table table) {
        this.logger.info("Adjust sequences for table [{}]", (Object)table.getName());
        this.wrappedSink.adjustSequences(table);
    }

    @Override
    public void close() throws Exception {
        this.wrappedSink.close();
    }

    @Override
    public boolean supportAlterAndDropField() {
        return this.wrappedSink.supportAlterAndDropField();
    }
}

