/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.helper;

public class JdbcUrl {
    public static final String SQLITE_TYPE = "sqlite";

    public static String getDatabaseTypeFromUrl(String jdbcUrl) {
        if (jdbcUrl == null || !jdbcUrl.startsWith("jdbc:")) {
            return null;
        }
        String urlWithoutPrefix = jdbcUrl.substring(5);
        int colonIndex = urlWithoutPrefix.indexOf(58);
        int slashIndex = urlWithoutPrefix.indexOf("//");
        if (colonIndex == -1 && slashIndex == -1) {
            return urlWithoutPrefix;
        }
        int endIndex = Math.min(colonIndex >= 0 ? colonIndex : Integer.MAX_VALUE, slashIndex >= 0 ? slashIndex : Integer.MAX_VALUE);
        return urlWithoutPrefix.substring(0, endIndex).toLowerCase();
    }

    public static boolean isDialectUrl(String dialect, String jdbcUrl) {
        return JdbcUrl.getDatabaseTypeFromUrl(jdbcUrl).equals(dialect);
    }
}

