/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.core.prepost.db_schema_version;

import ch.ergon.adam.core.db.interfaces.SchemaSource;
import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.Table;
import com.google.common.collect.Lists;
import java.io.IOException;

public class DbSchemaVersionSource
implements SchemaSource {
    public static final String SCHEMA_VERSION_TABLE_NAME = "db_schema_version";

    @Override
    public Schema getSchema() {
        Schema schema = new Schema();
        Table table = new Table(SCHEMA_VERSION_TABLE_NAME);
        Field id = this.createField("id", DataType.BIGINT, null, false);
        id.setSequence(true);
        Field sourceVersion = this.createField("source_version", DataType.VARCHAR, 50, true);
        Field targetVersion = this.createField("target_version", DataType.VARCHAR, 50, false);
        Field executionStartedAt = this.createField("execution_started_at", DataType.TIMESTAMPWITHTIMEZONE, null, false);
        Field executionCompletedAt = this.createField("execution_completed_at", DataType.TIMESTAMPWITHTIMEZONE, null, true);
        Field error = this.createField("error", DataType.VARCHAR, 2000, true);
        table.setFields(Lists.newArrayList((Object[])new Field[]{id, sourceVersion, targetVersion, executionStartedAt, executionCompletedAt, error}));
        Index primaryKey = new Index("db_schema_version_pkey");
        primaryKey.setPrimary(true);
        primaryKey.setUnique(true);
        primaryKey.setFields(Lists.newArrayList((Object[])new Field[]{id}));
        table.setIndexes(Lists.newArrayList((Object[])new Index[]{primaryKey}));
        schema.setTables(Lists.newArrayList((Object[])new Table[]{table}));
        return schema;
    }

    private Field createField(String name, DataType type, Integer length, boolean nullable) {
        Field field = new Field(name);
        field.setNullable(nullable);
        field.setDataType(type);
        field.setLength(length);
        return field;
    }

    @Override
    public void close() throws IOException {
    }
}

