/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.jooq;

import ch.ergon.adam.core.db.interfaces.SchemaSource;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.helper.CollectorsHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.CloseableDSLContext;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Meta;
import org.jooq.Named;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;

public class JooqSource
implements SchemaSource {
    private final Connection connection;
    private final String schemaName;
    private DSLContext context;
    private Meta meta;
    private SQLDialect sqlDialect = SQLDialect.DEFAULT;

    public JooqSource(String url, String schemaName) throws SQLException {
        this.connection = DriverManager.getConnection(url);
        this.schemaName = schemaName;
    }

    public JooqSource(Connection connection, String schemaName) {
        this.connection = connection;
        this.schemaName = schemaName;
    }

    public JooqSource(String url) throws SQLException {
        this.connection = DriverManager.getConnection(url);
        this.schemaName = null;
    }

    public JooqSource(Connection connection) {
        this.connection = connection;
        this.schemaName = null;
    }

    protected void setSqlDialect(SQLDialect dialect) {
        if (this.context != null) {
            throw new IllegalStateException("Context has already been created");
        }
        this.sqlDialect = dialect;
    }

    protected Meta getMeta() {
        if (this.meta == null) {
            this.meta = this.extractMeta(this.schemaName);
        }
        return this.meta;
    }

    protected DSLContext getContext() {
        if (this.context == null) {
            this.context = DSL.using((Connection)this.connection, (SQLDialect)this.sqlDialect);
        }
        return this.context;
    }

    private Meta extractMeta(String schemaName) {
        if (schemaName == null) {
            return this.getContext().meta();
        }
        List schemas = this.getContext().meta().getSchemas(schemaName);
        if (schemas.isEmpty()) {
            String knownSchemas = this.getContext().meta().getSchemas().stream().map(Named::getName).collect(Collectors.joining(","));
            throw new RuntimeException("Schema [" + schemaName + "] not found. Known schemas are [" + knownSchemas + "]");
        }
        return this.getContext().meta(new org.jooq.Schema[]{(org.jooq.Schema)schemas.get(0)});
    }

    public void close() {
        if (this.context instanceof CloseableDSLContext) {
            ((CloseableDSLContext)this.context).close();
        }
    }

    public Schema getSchema() {
        this.context = null;
        this.meta = null;
        Schema schema = new Schema();
        schema.setTables(this.getTables());
        return schema;
    }

    private Collection<Table> getTables() {
        List jooqTables = this.getMeta().getTables();
        Map tables = (Map)jooqTables.stream().map(this::mapTableFromJooq).sorted(Comparator.comparing(SchemaItem::getName)).collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        this.mapForeignKeys(jooqTables, tables);
        return tables.values();
    }

    private void mapForeignKeys(List<org.jooq.Table<?>> jooqTables, Map<String, Table> tables) {
        for (org.jooq.Table<?> jooqTable : jooqTables) {
            Table table = tables.get(jooqTable.getName());
            table.setForeignKeys(jooqTable.getReferences().stream().map(fk -> this.mapForeignKeyFromJooq(tables, (org.jooq.ForeignKey<?, ?>)fk)).collect(Collectors.toList()));
        }
    }

    private ForeignKey mapForeignKeyFromJooq(Map<String, Table> tables, org.jooq.ForeignKey<?, ?> jooqForeignKey) {
        Table table = tables.get(jooqForeignKey.getTable().getName());
        ForeignKey foreignKey = new ForeignKey(jooqForeignKey.getName());
        if (jooqForeignKey.getFields().size() != 1) {
            throw new RuntimeException("Table [" + table.getName() + "] contains a foreign key over multiple fields. This is not yet supported.");
        }
        foreignKey.setField(table.getField(((TableField)jooqForeignKey.getFields().get(0)).getName()));
        Table foreignTable = tables.get(jooqForeignKey.getKey().getTable().getName());
        foreignKey.setTargetIndex(foreignTable.getIndex(jooqForeignKey.getKey().getName()));
        return foreignKey;
    }

    private Table mapTableFromJooq(org.jooq.Table<?> jooqTable) {
        Table table = new Table(jooqTable.getName());
        table.setFields((Collection)Arrays.stream(jooqTable.fields()).map(this::mapFieldFromJooq).collect(Collectors.toList()));
        table.setIndexes(jooqTable.getIndexes().stream().map(jooqIndex -> this.mapIndexFromJooq(table, (org.jooq.Index)jooqIndex)).collect(Collectors.toList()));
        return table;
    }

    private Index mapIndexFromJooq(Table table, org.jooq.Index jooqIndex) {
        Index index = new Index(jooqIndex.getName());
        index.setFields(jooqIndex.getFields().stream().map(jooqField -> table.getField(jooqField.getName())).collect(Collectors.toList()));
        index.setUnique(jooqIndex.getUnique());
        UniqueKey primaryKey = jooqIndex.getTable().getPrimaryKey();
        if (primaryKey != null) {
            Object[] primaryKeyFieldNames = (String[])primaryKey.getFields().stream().map(Field::getName).toArray(String[]::new);
            Object[] indexFieldNames = (String[])jooqIndex.getFields().stream().map(SortField::getName).toArray(String[]::new);
            index.setPrimary(Arrays.equals(primaryKeyFieldNames, indexFieldNames));
        }
        return index;
    }

    private ch.ergon.adam.core.db.schema.Field mapFieldFromJooq(Field<?> jooqField) {
        ch.ergon.adam.core.db.schema.Field field = new ch.ergon.adam.core.db.schema.Field(jooqField.getName());
        field.setArray(jooqField.getDataType().isArray());
        field.setDataType(this.mapDataTypeFromJooq(jooqField));
        DataType jooqType = jooqField.getDataType(this.getContext().configuration());
        field.setNullable(jooqType.nullable());
        DataType elementType = field.isArray() ? jooqType.getArrayComponentDataType() : jooqType;
        field.setLength(elementType.hasLength() && elementType.length() < 20000000 ? Integer.valueOf(elementType.length()) : null);
        field.setPrecision(elementType.hasPrecision() && elementType.precision() < 10000 ? Integer.valueOf(elementType.precision()) : null);
        field.setScale(elementType.hasScale() ? Integer.valueOf(elementType.scale()) : null);
        field.setSequence(this.isSequence(jooqField));
        if (!field.isSequence() && jooqField.getDataType().defaulted()) {
            field.setDefaultValue(this.getDefaultValue(jooqField));
        }
        return field;
    }

    protected String getDefaultValue(Field<?> jooqField) {
        Field defaultValue = jooqField.getDataType().defaultValue();
        return defaultValue.getName();
    }

    protected boolean isSequence(Field<?> jooqField) {
        return jooqField.getDataType().identity();
    }

    protected ch.ergon.adam.core.db.schema.DataType mapDataTypeFromJooq(Field<?> jooqField) {
        String typeName = jooqField.getDataType().getSQLDataType().getTypeName();
        try {
            return ch.ergon.adam.core.db.schema.DataType.valueOf((String)typeName.toUpperCase().replace(" ", ""));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unknown type [" + typeName + "]");
        }
    }
}

