/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.jooq;

import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.PrimaryKeyConstraint;
import ch.ergon.adam.core.db.schema.RuleConstraint;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.core.helper.CollectorsHelper;
import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.CloseableDSLContext;
import org.jooq.Constraint;
import org.jooq.ConstraintEnforcementStep;
import org.jooq.ConstraintForeignKeyOnStep;
import org.jooq.CreateIndexStep;
import org.jooq.CreateSequenceFlagsStep;
import org.jooq.CreateTableColumnStep;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class JooqSink
implements SchemaSink {
    protected final DSLContext context;
    protected final String schema;

    public JooqSink(String url, String schema) {
        this.context = DSL.using((String)url);
        this.schema = schema;
    }

    public JooqSink(String url) {
        this.context = DSL.using((String)url);
        this.schema = null;
    }

    public JooqSink(Connection connection, SQLDialect dialect) {
        this.context = DSL.using((Connection)connection, (SQLDialect)dialect);
        this.schema = null;
    }

    protected JooqSink(Connection dbConnection, SQLDialect dialect, String schema) {
        this.context = DSL.using((Connection)dbConnection, (SQLDialect)dialect);
        this.context.createSchemaIfNotExists(schema).execute();
        this.schema = schema;
    }

    public void close() {
        if (this.context instanceof CloseableDSLContext) {
            ((CloseableDSLContext)this.context).close();
        }
    }

    protected Name getTableName(Table table) {
        return DSL.name((String[])new String[]{this.schema, table.getName()});
    }

    protected Name getFieldName(ch.ergon.adam.core.db.schema.Field field) {
        return DSL.name((String)field.getName());
    }

    public void setTargetSchema(Schema targetSchema) {
    }

    public void commitChanges() {
    }

    public void rollback() {
    }

    public void dropForeignKey(ForeignKey foreignKey) {
        this.context.alterTable(foreignKey.getTable().getName()).dropConstraint(foreignKey.getName()).execute();
    }

    public void createForeignKey(ForeignKey foreignKey) {
        Index targetIndex = foreignKey.getTargetIndex();
        ConstraintForeignKeyOnStep constraint = DSL.constraint((String)foreignKey.getName()).foreignKey(foreignKey.getField().getName()).references(targetIndex.getTable().getName(), ((ch.ergon.adam.core.db.schema.Field)targetIndex.getFields().get(0)).getName());
        this.context.alterTable(foreignKey.getTable().getName()).add((Constraint)constraint).execute();
    }

    public void dropIndex(Index index) {
        this.context.dropIndex(index.getName()).on(this.getTableName(index.getTable())).execute();
    }

    public void createIndex(Index index) {
        if (index.isPrimary()) {
            ConstraintEnforcementStep primaryKey = DSL.constraint((String)index.getName()).primaryKey(CollectorsHelper.createSchemaItemNameArray((Collection)index.getFields()));
            this.context.alterTable(index.getTable().getName()).add((Constraint)primaryKey).execute();
        } else {
            Collection fieldNames = index.getFields().stream().map(this::getFieldName).collect(Collectors.toList());
            CreateIndexStep createIndex = index.isUnique() ? this.context.createUniqueIndex(index.getName()) : this.context.createIndex(index.getName());
            createIndex.on(this.getTableName(index.getTable()), fieldNames).execute();
        }
    }

    public void addField(ch.ergon.adam.core.db.schema.Field field) {
        this.context.alterTable(this.getTableName(field.getTable())).addColumn(field.getName(), this.mapType(field)).execute();
        if (field.getSqlForNew() != null) {
            this.context.execute(String.format("UPDATE \"%s\" SET \"%s\" = %s", field.getTable().getName(), field.getName(), field.getSqlForNew()));
        }
    }

    public void dropField(ch.ergon.adam.core.db.schema.Field field, Table table) {
        this.context.alterTable(this.getTableName(table)).dropColumn(field.getName()).execute();
    }

    public void dropDefault(ch.ergon.adam.core.db.schema.Field field) {
        this.context.alterTable(this.getTableName(field.getTable())).alterColumn(field.getName()).defaultValue(DSL.field((String)"null")).execute();
    }

    public void setDefault(ch.ergon.adam.core.db.schema.Field field) {
        if (field.getDefaultValue() == null) {
            this.dropDefault(field);
            return;
        }
        this.context.alterTable(this.getTableName(field.getTable())).alterColumn(field.getName()).defaultValue(this.getDefaultValue(field)).execute();
    }

    public void createTable(Table table) {
        CreateTableColumnStep createTable = this.context.createTable(this.getTableName(table));
        CreateTableColumnStep addRows = null;
        for (ch.ergon.adam.core.db.schema.Field field : table.getFields()) {
            if (addRows == null) {
                addRows = createTable.column(field.getName(), this.mapType(field));
                continue;
            }
            addRows = addRows.column(field.getName(), this.mapType(field));
        }
        if (addRows == null) {
            throw new RuntimeException("Table [" + table.getName() + "] without a row is not supported.");
        }
        addRows.execute();
    }

    public void dropTable(Table table) {
        this.context.dropTable(this.getTableName(table)).execute();
    }

    public void createView(View view) {
        this.context.execute(String.format("CREATE VIEW \"%s\" AS %s", view.getName(), view.getViewDefinition()));
    }

    public void dropView(View view) {
        this.context.dropView(view.getName()).execute();
    }

    public void dropEnum(DbEnum dbEnum) {
        throw new RuntimeException("Not implemented");
    }

    public void createEnum(DbEnum dbEnum) {
        throw new RuntimeException("Not implemented");
    }

    public void changeFieldType(ch.ergon.adam.core.db.schema.Field oldField, ch.ergon.adam.core.db.schema.Field newField, ch.ergon.adam.core.db.schema.DataType targetDataType) {
        DataType<?> newType = targetDataType == newField.getDataType() ? this.mapType(newField) : this.mapRawType(targetDataType);
        this.context.alterTable(oldField.getTable().getName()).alterColumn(oldField.getName()).set(newType).execute();
    }

    public void dropConstraint(ch.ergon.adam.core.db.schema.Constraint constraint) {
        this.context.alterTable(constraint.getTable().getName()).dropConstraint(constraint.getName()).execute();
    }

    public void createConstraint(ch.ergon.adam.core.db.schema.Constraint constraint) {
        if (constraint instanceof RuleConstraint) {
            RuleConstraint rule = (RuleConstraint)constraint;
            ConstraintEnforcementStep check = DSL.constraint((String)constraint.getName()).check(DSL.condition((String)rule.getRule()));
            this.context.alterTable(constraint.getTable().getName()).add((Constraint)check).execute();
        } else if (!(constraint instanceof PrimaryKeyConstraint)) {
            throw new RuntimeException("Not implemented");
        }
    }

    public void dropSequence(Sequence sequence) {
        this.context.dropSequence(sequence.getName()).execute();
    }

    public void createSequence(Sequence sequence) {
        CreateSequenceFlagsStep sequenceCreate = this.context.createSequence(sequence.getName());
        if (sequence.getStartValue() != null) {
            sequenceCreate.startWith((Number)sequence.getStartValue());
        }
        if (sequence.getMinValue() != null) {
            sequenceCreate.minvalue((Number)sequence.getMinValue());
        }
        if (sequence.getMaxValue() != null) {
            sequenceCreate.maxvalue((Number)sequence.getMaxValue());
        }
        if (sequence.getIncrement() != null) {
            sequenceCreate.incrementBy((Number)sequence.getIncrement());
        }
        sequenceCreate.execute();
    }

    public void dropSequencesAndDefaults(Table table) {
        table.getFields().stream().filter(ch.ergon.adam.core.db.schema.Field::isSequence).forEach(field -> this.context.alterTable(table.getName()).alterColumn(field.getName()).defaultValue(DSL.field((String)"null")).execute());
    }

    public void renameTable(Table oldTable, String targetTableName) {
        this.context.alterTable(this.getTableName(oldTable)).renameTo(targetTableName).execute();
    }

    public void copyData(Table sourceTable, Table targetTable, String sourceTableName) {
        Map fieldsToCopy = (Map)targetTable.getFields().stream().filter(targetField -> sourceTable.getField(targetField.getName()) != null).collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        Map fieldsWithMigration = (Map)targetTable.getFields().stream().filter(targetField -> sourceTable.getField(targetField.getName()) == null).filter(targetField -> targetField.getSqlForNew() != null).collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        String fieldNames = Stream.concat(fieldsToCopy.values().stream().map(SchemaItem::getName), fieldsWithMigration.values().stream().map(SchemaItem::getName)).map(name -> "\"" + name + "\"").collect(Collectors.joining(","));
        if (fieldNames.isEmpty()) {
            return;
        }
        String values = Stream.concat(fieldsToCopy.values().stream().map(field -> this.castIfNeeded(sourceTable.getField(field.getName()), (ch.ergon.adam.core.db.schema.Field)field, this.context)), fieldsWithMigration.values().stream().map(field -> field.getSqlForNew())).collect(Collectors.joining(","));
        this.context.execute(String.format("INSERT INTO \"%s\" (%s) select %s from \"%s\" ", targetTable.getName(), fieldNames, values, sourceTableName));
    }

    protected String castIfNeeded(ch.ergon.adam.core.db.schema.Field sourceField, ch.ergon.adam.core.db.schema.Field targetField, DSLContext renderContext) {
        if (sourceField.getDataType() == targetField.getDataType() && (sourceField.getDataType() != ch.ergon.adam.core.db.schema.DataType.ENUM || sourceField.getDbEnum().equals(targetField.getDbEnum()))) {
            return "\"" + targetField.getName() + "\"";
        }
        DataType<?> targetType = this.mapType(targetField);
        Field jooqField = DSL.field((String)("\"" + targetField.getName() + "\""));
        return renderContext.render((QueryPart)DSL.cast((Field)jooqField, targetType));
    }

    protected DataType<?> mapType(ch.ergon.adam.core.db.schema.Field field) {
        DataType jooqType = this.mapFieldToJooqType(field);
        if (field.getLength() != null && jooqType.hasLength()) {
            jooqType = jooqType.length(field.getLength().intValue());
        }
        if (field.isArray()) {
            jooqType = jooqType.getArrayDataType();
        }
        jooqType = jooqType.nullable(field.isNullable());
        jooqType = jooqType.identity(field.isSequence());
        if (field.getPrecision() != null && jooqType.hasPrecision() && jooqType.getSQLDataType() != SQLDataType.TIMESTAMPWITHTIMEZONE) {
            jooqType = jooqType.precision(field.getPrecision().intValue());
        }
        if (field.getScale() != null && jooqType.hasScale()) {
            jooqType = jooqType.scale(field.getScale().intValue());
        }
        if (field.getDefaultValue() != null) {
            jooqType = jooqType.defaultValue(this.getDefaultValue(field));
        }
        return jooqType;
    }

    protected Object getDefaultValue(ch.ergon.adam.core.db.schema.Field field) {
        return DSL.field((String)field.getDefaultValue());
    }

    protected DataType<?> mapFieldToJooqType(ch.ergon.adam.core.db.schema.Field field) {
        return this.mapRawType(field.getDataType());
    }

    protected DataType<?> mapRawType(ch.ergon.adam.core.db.schema.DataType type) {
        DataType jooqType;
        switch (type) {
            case VARCHAR: {
                jooqType = SQLDataType.VARCHAR;
                break;
            }
            case CHAR: {
                jooqType = SQLDataType.CHAR;
                break;
            }
            case LONGVARCHAR: {
                jooqType = SQLDataType.LONGVARCHAR;
                break;
            }
            case CLOB: {
                jooqType = SQLDataType.CLOB;
                break;
            }
            case NVARCHAR: {
                jooqType = SQLDataType.NVARCHAR;
                break;
            }
            case NCHAR: {
                jooqType = SQLDataType.NCHAR;
                break;
            }
            case LONGNVARCHAR: {
                jooqType = SQLDataType.LONGNVARCHAR;
                break;
            }
            case NCLOB: {
                jooqType = SQLDataType.NCLOB;
                break;
            }
            case BOOLEAN: {
                jooqType = SQLDataType.BOOLEAN;
                break;
            }
            case BIT: {
                jooqType = SQLDataType.BIT;
                break;
            }
            case TINYINT: {
                jooqType = SQLDataType.TINYINT;
                break;
            }
            case SMALLINT: {
                jooqType = SQLDataType.SMALLINT;
                break;
            }
            case INTEGER: {
                jooqType = SQLDataType.INTEGER;
                break;
            }
            case BIGINT: {
                jooqType = SQLDataType.BIGINT;
                break;
            }
            case DECIMAL_INTEGER: {
                jooqType = SQLDataType.DECIMAL_INTEGER;
                break;
            }
            case TINYINTUNSIGNED: {
                jooqType = SQLDataType.TINYINTUNSIGNED;
                break;
            }
            case SMALLINTUNSIGNED: {
                jooqType = SQLDataType.SMALLINTUNSIGNED;
                break;
            }
            case INTEGERUNSIGNED: {
                jooqType = SQLDataType.INTEGERUNSIGNED;
                break;
            }
            case BIGINTUNSIGNED: {
                jooqType = SQLDataType.BIGINTUNSIGNED;
                break;
            }
            case DOUBLE: {
                jooqType = SQLDataType.DOUBLE;
                break;
            }
            case FLOAT: {
                jooqType = SQLDataType.FLOAT;
                break;
            }
            case REAL: {
                jooqType = SQLDataType.REAL;
                break;
            }
            case NUMERIC: {
                jooqType = SQLDataType.NUMERIC;
                break;
            }
            case DECIMAL: {
                jooqType = SQLDataType.DECIMAL;
                break;
            }
            case DATE: {
                jooqType = SQLDataType.DATE;
                break;
            }
            case TIMESTAMP: {
                jooqType = SQLDataType.TIMESTAMP;
                break;
            }
            case TIME: {
                jooqType = SQLDataType.TIME;
                break;
            }
            case INTERVALYEARTOMONTH: {
                jooqType = SQLDataType.INTERVALYEARTOMONTH;
                break;
            }
            case INTERVALDAYTOSECOND: {
                jooqType = SQLDataType.INTERVALDAYTOSECOND;
                break;
            }
            case LOCALDATE: {
                jooqType = SQLDataType.LOCALDATE;
                break;
            }
            case LOCALTIME: {
                jooqType = SQLDataType.LOCALTIME;
                break;
            }
            case LOCALDATETIME: {
                jooqType = SQLDataType.LOCALDATETIME;
                break;
            }
            case OFFSETTIME: {
                jooqType = SQLDataType.OFFSETTIME;
                break;
            }
            case OFFSETDATETIME: {
                jooqType = SQLDataType.OFFSETDATETIME;
                break;
            }
            case TIMEWITHTIMEZONE: {
                jooqType = SQLDataType.TIMEWITHTIMEZONE;
                break;
            }
            case TIMESTAMPWITHTIMEZONE: {
                jooqType = SQLDataType.TIMESTAMPWITHTIMEZONE;
                break;
            }
            case BINARY: {
                jooqType = SQLDataType.BINARY;
                break;
            }
            case VARBINARY: {
                jooqType = SQLDataType.VARBINARY;
                break;
            }
            case LONGVARBINARY: {
                jooqType = SQLDataType.LONGVARBINARY;
                break;
            }
            case BLOB: {
                jooqType = SQLDataType.BLOB;
                break;
            }
            case UUID: {
                jooqType = SQLDataType.UUID;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported datatype [" + type + "]");
            }
        }
        return jooqType.getDataType(this.context.configuration());
    }
}

