/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.jooq;

import ch.ergon.adam.core.db.interfaces.SchemaSource;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.core.helper.CollectorsHelper;
import ch.ergon.adam.jooq.JooqUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.CloseableDSLContext;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Key;
import org.jooq.Meta;
import org.jooq.SQLDialect;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.types.DayToSecond;
import org.jooq.types.YearToMonth;
import org.jooq.types.YearToSecond;

public abstract class JooqSource
implements SchemaSource {
    private final Connection connection;
    private final String schemaName;
    private DSLContext context;
    private Meta meta;
    private SQLDialect sqlDialect = SQLDialect.DEFAULT;

    public JooqSource(String url, String schemaName) throws SQLException {
        this.connection = DriverManager.getConnection(url);
        this.schemaName = schemaName;
    }

    public JooqSource(Connection connection, String schemaName) {
        this.connection = connection;
        this.schemaName = schemaName;
    }

    public JooqSource(String url) throws SQLException {
        this.connection = DriverManager.getConnection(url);
        this.schemaName = null;
    }

    public JooqSource(Connection connection) {
        this.connection = connection;
        this.schemaName = null;
    }

    protected void setSqlDialect(SQLDialect dialect) {
        if (this.context != null) {
            throw new IllegalStateException("Context has already been created");
        }
        this.sqlDialect = dialect;
    }

    protected Meta getMeta() {
        if (this.meta == null) {
            this.meta = JooqUtils.extractMeta(this.getContext(), this.schemaName);
        }
        return this.meta;
    }

    protected DSLContext getContext() {
        if (this.context == null) {
            this.context = DSL.using((Connection)this.connection, (SQLDialect)this.sqlDialect);
        }
        return this.context;
    }

    public void close() {
        if (this.context instanceof CloseableDSLContext) {
            ((CloseableDSLContext)this.context).close();
        }
    }

    public Schema getSchema() {
        this.context = null;
        this.meta = null;
        Schema schema = new Schema();
        schema.setTables(this.getTables());
        schema.setViews(this.getViews());
        this.setViewDependencies(schema);
        return schema;
    }

    private Collection<Table> getTables() {
        List<org.jooq.Table<?>> jooqTables = this.getMeta().getTables();
        jooqTables = jooqTables.stream().filter(table -> table.getOptions().type() == TableOptions.TableType.TABLE).toList();
        Map tables = (Map)jooqTables.stream().map(this::mapTableFromJooq).sorted(Comparator.comparing(SchemaItem::getName)).collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        this.mapForeignKeys(jooqTables, tables);
        return tables.values();
    }

    private Collection<View> getViews() {
        List jooqTables = this.getMeta().getTables();
        Map views = (Map)jooqTables.stream().filter(table -> table.getOptions().type() == TableOptions.TableType.VIEW).map(this::mapViewFromJooq).sorted(Comparator.comparing(SchemaItem::getName)).collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        return views.values();
    }

    private void setViewDependencies(Schema schema) {
        Map<String, List<String>> dependencies = this.fetchViewDependencies();
        schema.getViews().stream().filter(v -> dependencies.containsKey(v.getName())).forEach(v -> ((List)dependencies.get(v.getName())).stream().map(base -> {
            Table r = schema.getTable(base);
            if (r == null) {
                r = schema.getView(base);
            }
            return r;
        }).filter(Objects::nonNull).forEach(arg_0 -> ((View)v).addBaseRelation(arg_0)));
    }

    private void mapForeignKeys(List<org.jooq.Table<?>> jooqTables, Map<String, Table> tables) {
        for (org.jooq.Table<?> jooqTable : jooqTables) {
            Table table = tables.get(jooqTable.getName());
            table.setForeignKeys(jooqTable.getReferences().stream().map(fk -> this.mapForeignKeyFromJooq(tables, (org.jooq.ForeignKey<?, ?>)fk)).collect(Collectors.toList()));
        }
    }

    private ForeignKey mapForeignKeyFromJooq(Map<String, Table> tables, org.jooq.ForeignKey<?, ?> jooqForeignKey) {
        Table table = tables.get(jooqForeignKey.getTable().getName());
        String name = jooqForeignKey.getName();
        if (this.isGeneratedName(name)) {
            name = null;
        }
        ForeignKey foreignKey = new ForeignKey(name);
        if (jooqForeignKey.getFields().size() != 1) {
            throw new RuntimeException("Table [" + table.getName() + "] contains a foreign key over multiple fields. This is not yet supported.");
        }
        foreignKey.setField(table.getField(((TableField)jooqForeignKey.getFields().get(0)).getName()));
        Table foreignTable = tables.get(jooqForeignKey.getKey().getTable().getName());
        foreignKey.setTargetIndex(foreignTable.getIndex(jooqForeignKey.getKey().getName()));
        return foreignKey;
    }

    protected boolean isGeneratedName(String name) {
        return false;
    }

    private Table mapTableFromJooq(org.jooq.Table<?> jooqTable) {
        Table table = new Table(jooqTable.getName());
        table.setFields((Collection)Arrays.stream(jooqTable.fields()).map(this::mapFieldFromJooq).collect(Collectors.toList()));
        List indexes = jooqTable.getIndexes().stream().map(jooqIndex -> this.mapIndexFromJooq(table, (org.jooq.Index)jooqIndex)).collect(Collectors.toList());
        if (jooqTable.getPrimaryKey() != null) {
            indexes.add(this.mapPrimaryKeyFromJooq(table, jooqTable.getPrimaryKey()));
        }
        jooqTable.getUniqueKeys().stream().map(jooqKey -> this.mapUniqueKeyFromJooq(table, (UniqueKey<?>)jooqKey)).forEach(indexes::add);
        table.setIndexes(indexes);
        return table;
    }

    private View mapViewFromJooq(org.jooq.Table<?> jooqTable) {
        View view = new View(jooqTable.getName());
        view.setFields((Collection)Arrays.stream(jooqTable.fields()).map(this::mapFieldFromJooq).collect(Collectors.toList()));
        view.setViewDefinition(this.getViewDefinition(view.getName()));
        return view;
    }

    protected abstract String getViewDefinition(String var1);

    protected abstract Map<String, List<String>> fetchViewDependencies();

    private Index mapPrimaryKeyFromJooq(Table table, UniqueKey<?> primaryKey) {
        Index index = this.mapUniqueKeyFromJooq(table, primaryKey);
        index.setPrimary(true);
        return index;
    }

    private Index mapUniqueKeyFromJooq(Table table, UniqueKey<?> uniqueKey) {
        Index index = this.mapKeyFromJooq(table, (Key<?>)uniqueKey);
        index.setUnique(true);
        return index;
    }

    private Index mapIndexFromJooq(Table table, org.jooq.Index jooqIndex) {
        Index index = new Index(jooqIndex.getName());
        if (jooqIndex.getWhere() != null) {
            index.setWhere(jooqIndex.getWhere().toString());
        }
        index.setUnique(jooqIndex.getUnique());
        index.setFields(jooqIndex.getFields().stream().map(jooqField -> table.getField(jooqField.getName())).filter(Objects::nonNull).collect(Collectors.toList()));
        return index;
    }

    private Index mapKeyFromJooq(Table table, Key<?> jooqKey) {
        Index index = new Index(jooqKey.getName());
        index.setFields(jooqKey.getFields().stream().map(jooqField -> table.getField(jooqField.getName())).filter(Objects::nonNull).collect(Collectors.toList()));
        return index;
    }

    protected ch.ergon.adam.core.db.schema.Field mapFieldFromJooq(Field<?> jooqField) {
        ch.ergon.adam.core.db.schema.Field field = new ch.ergon.adam.core.db.schema.Field(jooqField.getName());
        field.setArray(jooqField.getDataType().isArray());
        field.setDataType(this.mapDataTypeFromJooq(jooqField));
        DataType jooqType = jooqField.getDataType(this.getContext().configuration());
        field.setNullable(jooqType.nullable());
        DataType elementType = field.isArray() ? jooqType.getArrayComponentDataType() : jooqType;
        field.setLength(elementType.hasLength() && elementType.length() > 0 && elementType.length() < 20000000 ? Integer.valueOf(elementType.length()) : null);
        field.setPrecision(elementType.hasPrecision() && elementType.precision() > 0 && elementType.precision() < 10000 ? Integer.valueOf(elementType.precision()) : null);
        field.setScale(elementType.hasScale() && elementType.scale() > 0 ? Integer.valueOf(elementType.scale()) : null);
        field.setSequence(this.isSequence(jooqField));
        if (!field.isSequence() && jooqField.getDataType().defaulted()) {
            field.setDefaultValue(this.getDefaultValue(jooqField));
        }
        return field;
    }

    protected String getDefaultValue(Field<?> jooqField) {
        Field defaultValue = jooqField.getDataType().defaultValue();
        return defaultValue.toString();
    }

    protected boolean isSequence(Field<?> jooqField) {
        return jooqField.getDataType().identity();
    }

    protected ch.ergon.adam.core.db.schema.DataType mapDataTypeFromJooq(Field<?> jooqField) {
        DataType sqlDataType = jooqField.getDataType().getSQLDataType();
        if (sqlDataType.isInterval()) {
            Class type = sqlDataType.getType();
            if (type.equals(YearToSecond.class)) {
                return ch.ergon.adam.core.db.schema.DataType.INTERVALYEARTOSECOND;
            }
            if (type.equals(YearToMonth.class)) {
                return ch.ergon.adam.core.db.schema.DataType.INTERVALYEARTOMONTH;
            }
            if (type.equals(DayToSecond.class)) {
                return ch.ergon.adam.core.db.schema.DataType.INTERVALDAYTOSECOND;
            }
            throw new RuntimeException("Unsupported interval type [" + type.getName() + "]");
        }
        if (sqlDataType.isNumeric() && jooqField.getDataType().precision() == 0 && jooqField.getDataType().scale() == 0) {
            return ch.ergon.adam.core.db.schema.DataType.DECIMAL_INTEGER;
        }
        String typeName = jooqField.getDataType().isArray() ? sqlDataType.getArrayBaseDataType().getTypeName() : sqlDataType.getTypeName();
        try {
            return ch.ergon.adam.core.db.schema.DataType.valueOf((String)typeName.toUpperCase().replace(" ", ""));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unknown type [" + typeName + "]");
        }
    }
}

