/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.jooq;

import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.PrimaryKeyConstraint;
import ch.ergon.adam.core.db.schema.RuleConstraint;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.core.helper.CollectorsHelper;
import ch.ergon.adam.jooq.JooqUtils;
import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.CloseableDSLContext;
import org.jooq.Constraint;
import org.jooq.ConstraintEnforcementStep;
import org.jooq.ConstraintForeignKeyOnStep;
import org.jooq.CreateIndexIncludeStep;
import org.jooq.CreateIndexStep;
import org.jooq.CreateSequenceFlagsStep;
import org.jooq.CreateTableElementListStep;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;

public class JooqSink
implements SchemaSink {
    protected final DSLContext context;
    protected final String schema;

    public JooqSink(String url, String schema) {
        this.context = DSL.using((String)url);
        this.schema = schema;
    }

    public JooqSink(String url) {
        this.context = DSL.using((String)url);
        this.schema = null;
    }

    public JooqSink(Connection connection, SQLDialect dialect) {
        this.context = DSL.using((Connection)connection, (SQLDialect)dialect);
        this.schema = null;
    }

    protected JooqSink(Connection dbConnection, SQLDialect dialect, String schema) {
        this.context = DSL.using((Connection)dbConnection, (SQLDialect)dialect);
        if (!dialect.family().name().contains("ORACLE")) {
            this.context.createSchemaIfNotExists(schema).execute();
        }
        this.schema = schema;
    }

    public void close() {
        if (this.context instanceof CloseableDSLContext) {
            ((CloseableDSLContext)this.context).close();
        }
    }

    protected Name getTableName(Table table) {
        return DSL.name((String[])new String[]{this.schema, table.getName()});
    }

    protected Name getFieldName(ch.ergon.adam.core.db.schema.Field field) {
        return DSL.name((String)field.getName());
    }

    public void setTargetSchema(Schema targetSchema) {
        targetSchema.getEnums().forEach(e -> new DefaultDataType(null, Object.class, e.getName()));
    }

    public void commitChanges() {
    }

    public void rollback() {
    }

    public void dropForeignKey(ForeignKey foreignKey) {
        this.context.alterTable(foreignKey.getTable().getName()).dropConstraint(foreignKey.getName()).execute();
    }

    public void createForeignKey(ForeignKey foreignKey) {
        Index targetIndex = foreignKey.getTargetIndex();
        ConstraintForeignKeyOnStep constraint = DSL.constraint((String)foreignKey.getName()).foreignKey(foreignKey.getField().getName()).references(targetIndex.getTable().getName(), ((ch.ergon.adam.core.db.schema.Field)targetIndex.getFields().getFirst()).getName());
        this.context.alterTable(foreignKey.getTable().getName()).add((Constraint)constraint).execute();
    }

    public void dropIndex(Index index) {
        this.context.dropIndex(index.getName()).on(this.getTableName(index.getTable())).execute();
    }

    public void createIndex(Index index) {
        if (index.isPrimary()) {
            ConstraintEnforcementStep primaryKey = DSL.constraint((String)index.getName()).primaryKey(CollectorsHelper.createSchemaItemNameArray((Collection)index.getFields()));
            this.context.alterTable(index.getTable().getName()).add((Constraint)primaryKey).execute();
        } else {
            Collection fieldNames = index.getFields().stream().map(this::getFieldName).collect(Collectors.toList());
            CreateIndexStep createIndex = index.isUnique() ? this.context.createUniqueIndex(index.getName()) : this.context.createIndex(index.getName());
            CreateIndexIncludeStep indexStep = createIndex.on(this.getTableName(index.getTable()), fieldNames);
            if (index.getWhere() == null || index.getWhere().isEmpty()) {
                indexStep.execute();
            } else {
                indexStep.where(DSL.condition((String)index.getWhere())).execute();
            }
        }
    }

    public void addField(ch.ergon.adam.core.db.schema.Field field) {
        this.context.alterTable(this.getTableName(field.getTable())).addColumn(field.getName(), this.mapType(field)).execute();
        if (field.getSqlForNew() != null) {
            this.context.execute(JooqUtils.ensureCorrectEscaping(String.format("UPDATE \"%s\" SET \"%s\" = %s", field.getTable().getName(), field.getName(), field.getSqlForNew()), this.context.dialect()));
        }
    }

    public void dropField(ch.ergon.adam.core.db.schema.Field field, Table table) {
        this.context.alterTable(this.getTableName(table)).dropColumn(field.getName()).execute();
    }

    public void dropDefault(ch.ergon.adam.core.db.schema.Field field) {
        this.context.alterTable(this.getTableName(field.getTable())).alterColumn(field.getName()).defaultValue(DSL.field((String)"null")).execute();
    }

    public void setDefault(ch.ergon.adam.core.db.schema.Field field) {
        if (field.getDefaultValue() == null) {
            this.dropDefault(field);
            return;
        }
        this.context.alterTable(this.getTableName(field.getTable())).alterColumn(field.getName()).defaultValue(this.getDefaultValue(field)).execute();
    }

    public void createTable(Table table) {
        CreateTableElementListStep createTable = this.context.createTable(this.getTableName(table));
        CreateTableElementListStep addRows = null;
        for (ch.ergon.adam.core.db.schema.Field field : table.getFields()) {
            if (addRows == null) {
                addRows = createTable.column(field.getName(), this.mapType(field));
                continue;
            }
            addRows = addRows.column(field.getName(), this.mapType(field));
        }
        if (addRows == null) {
            throw new RuntimeException("Table [" + table.getName() + "] without a row is not supported.");
        }
        addRows.execute();
    }

    public void dropTable(Table table) {
        this.context.dropTable(this.getTableName(table)).execute();
    }

    public void createView(View view) {
        this.context.execute(JooqUtils.ensureCorrectEscaping(String.format("CREATE VIEW \"%s\" AS %s", view.getName(), view.getViewDefinition()), this.context.dialect()));
    }

    public void dropView(View view) {
        this.context.dropView(view.getName()).execute();
    }

    public void dropEnum(DbEnum dbEnum) {
        throw new RuntimeException("Not implemented");
    }

    public void createEnum(DbEnum dbEnum) {
        throw new RuntimeException("Not implemented");
    }

    public void changeFieldType(ch.ergon.adam.core.db.schema.Field oldField, ch.ergon.adam.core.db.schema.Field newField, ch.ergon.adam.core.db.schema.DataType targetDataType) {
        DataType<?> newType = targetDataType == newField.getDataType() ? this.mapType(newField) : this.mapRawType(targetDataType);
        this.context.alterTable(oldField.getTable().getName()).alterColumn(oldField.getName()).set(newType).execute();
    }

    public void dropConstraint(ch.ergon.adam.core.db.schema.Constraint constraint) {
        this.context.alterTable(constraint.getTable().getName()).dropConstraint(constraint.getName()).execute();
    }

    public void createConstraint(ch.ergon.adam.core.db.schema.Constraint constraint) {
        if (constraint instanceof RuleConstraint) {
            RuleConstraint rule = (RuleConstraint)constraint;
            ConstraintEnforcementStep check = DSL.constraint((String)constraint.getName()).check(DSL.condition((String)rule.getRule()));
            this.context.alterTable(constraint.getTable().getName()).add((Constraint)check).execute();
        } else if (!(constraint instanceof PrimaryKeyConstraint)) {
            throw new RuntimeException("Not implemented");
        }
    }

    public void dropSequence(Sequence sequence) {
        this.context.dropSequence(sequence.getName()).execute();
    }

    public void createSequence(Sequence sequence) {
        CreateSequenceFlagsStep sequenceCreate = this.context.createSequence(sequence.getName());
        if (sequence.getStartValue() != null) {
            sequenceCreate.startWith((Number)sequence.getStartValue());
        }
        if (sequence.getMinValue() != null) {
            sequenceCreate.minvalue((Number)sequence.getMinValue());
        }
        if (sequence.getMaxValue() != null) {
            sequenceCreate.maxvalue((Number)sequence.getMaxValue());
        }
        if (sequence.getIncrement() != null) {
            sequenceCreate.incrementBy((Number)sequence.getIncrement());
        }
        sequenceCreate.execute();
    }

    public void dropSequencesAndDefaults(Table table) {
        table.getFields().stream().filter(ch.ergon.adam.core.db.schema.Field::isSequence).forEach(field -> this.context.alterTable(table.getName()).alterColumn(field.getName()).dropDefault().execute());
    }

    public void adjustSequences(Table table) {
    }

    public void renameTable(Table oldTable, String targetTableName) {
        this.context.alterTable(this.getTableName(oldTable)).renameTo(targetTableName).execute();
    }

    public void copyData(Table sourceTable, Table targetTable, String sourceTableName) {
        Map fieldsToCopy = (Map)targetTable.getFields().stream().filter(targetField -> sourceTable.getField(targetField.getName()) != null).collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        Map fieldsWithMigration = (Map)targetTable.getFields().stream().filter(targetField -> sourceTable.getField(targetField.getName()) == null).filter(targetField -> targetField.getSqlForNew() != null).collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        String fieldNames = Stream.concat(fieldsToCopy.values().stream().map(SchemaItem::getName), fieldsWithMigration.values().stream().map(SchemaItem::getName)).map(name -> "\"" + name + "\"").collect(Collectors.joining(","));
        if (fieldNames.isEmpty()) {
            return;
        }
        String values = Stream.concat(fieldsToCopy.values().stream().map(field -> this.castIfNeeded(sourceTable.getField(field.getName()), (ch.ergon.adam.core.db.schema.Field)field, this.context)), fieldsWithMigration.values().stream().map(field -> field.getSqlForNew())).collect(Collectors.joining(","));
        this.context.execute(JooqUtils.ensureCorrectEscaping(String.format("INSERT INTO \"%s\" (%s) select %s from \"%s\" ", targetTable.getName(), fieldNames, values, sourceTableName), this.context.dialect()));
    }

    protected String castIfNeeded(ch.ergon.adam.core.db.schema.Field sourceField, ch.ergon.adam.core.db.schema.Field targetField, DSLContext renderContext) {
        if (sourceField.getDataType() == targetField.getDataType() && (sourceField.getDataType() != ch.ergon.adam.core.db.schema.DataType.ENUM || sourceField.getDbEnum().equals(targetField.getDbEnum()))) {
            return "\"" + targetField.getName() + "\"";
        }
        DataType<?> targetType = this.mapType(targetField);
        Field jooqField = DSL.field((String)("\"" + targetField.getName() + "\""));
        return renderContext.render((QueryPart)DSL.cast((Field)jooqField, targetType));
    }

    protected DataType<?> mapType(ch.ergon.adam.core.db.schema.Field field) {
        DataType jooqType = this.mapFieldToJooqType(field);
        if (field.getLength() != null && jooqType.hasLength()) {
            jooqType = jooqType.length(field.getLength().intValue());
        }
        if (field.isArray()) {
            jooqType = jooqType.getArrayDataType();
        }
        jooqType = jooqType.nullable(field.isNullable());
        jooqType = jooqType.identity(field.isSequence());
        if (field.getPrecision() != null && jooqType.hasPrecision() && jooqType.getSQLDataType() != SQLDataType.TIMESTAMPWITHTIMEZONE) {
            jooqType = jooqType.precision(field.getPrecision().intValue());
        }
        if (field.getScale() != null && jooqType.hasScale()) {
            jooqType = jooqType.scale(field.getScale().intValue());
        }
        if (field.getDefaultValue() != null) {
            jooqType = jooqType.defaultValue(this.getDefaultValue(field));
        }
        return jooqType;
    }

    protected Object getDefaultValue(ch.ergon.adam.core.db.schema.Field field) {
        return DSL.field((String)field.getDefaultValue());
    }

    protected DataType<?> mapFieldToJooqType(ch.ergon.adam.core.db.schema.Field field) {
        return this.mapRawType(field.getDataType());
    }

    protected DataType<?> mapRawType(ch.ergon.adam.core.db.schema.DataType type) {
        return (switch (type) {
            case ch.ergon.adam.core.db.schema.DataType.VARCHAR -> SQLDataType.VARCHAR;
            case ch.ergon.adam.core.db.schema.DataType.CHAR -> SQLDataType.CHAR;
            case ch.ergon.adam.core.db.schema.DataType.LONGVARCHAR -> SQLDataType.LONGVARCHAR;
            case ch.ergon.adam.core.db.schema.DataType.CLOB -> SQLDataType.CLOB;
            case ch.ergon.adam.core.db.schema.DataType.NVARCHAR -> SQLDataType.NVARCHAR;
            case ch.ergon.adam.core.db.schema.DataType.NCHAR -> SQLDataType.NCHAR;
            case ch.ergon.adam.core.db.schema.DataType.LONGNVARCHAR -> SQLDataType.LONGNVARCHAR;
            case ch.ergon.adam.core.db.schema.DataType.NCLOB -> SQLDataType.NCLOB;
            case ch.ergon.adam.core.db.schema.DataType.BOOLEAN -> SQLDataType.BOOLEAN;
            case ch.ergon.adam.core.db.schema.DataType.BIT -> SQLDataType.BIT;
            case ch.ergon.adam.core.db.schema.DataType.TINYINT -> SQLDataType.TINYINT;
            case ch.ergon.adam.core.db.schema.DataType.SMALLINT -> SQLDataType.SMALLINT;
            case ch.ergon.adam.core.db.schema.DataType.INTEGER -> SQLDataType.INTEGER;
            case ch.ergon.adam.core.db.schema.DataType.BIGINT -> SQLDataType.BIGINT;
            case ch.ergon.adam.core.db.schema.DataType.DECIMAL_INTEGER -> SQLDataType.DECIMAL_INTEGER;
            case ch.ergon.adam.core.db.schema.DataType.TINYINTUNSIGNED -> SQLDataType.TINYINTUNSIGNED;
            case ch.ergon.adam.core.db.schema.DataType.SMALLINTUNSIGNED -> SQLDataType.SMALLINTUNSIGNED;
            case ch.ergon.adam.core.db.schema.DataType.INTEGERUNSIGNED -> SQLDataType.INTEGERUNSIGNED;
            case ch.ergon.adam.core.db.schema.DataType.BIGINTUNSIGNED -> SQLDataType.BIGINTUNSIGNED;
            case ch.ergon.adam.core.db.schema.DataType.DOUBLE -> SQLDataType.DOUBLE;
            case ch.ergon.adam.core.db.schema.DataType.FLOAT -> SQLDataType.FLOAT;
            case ch.ergon.adam.core.db.schema.DataType.REAL -> SQLDataType.REAL;
            case ch.ergon.adam.core.db.schema.DataType.NUMERIC -> SQLDataType.NUMERIC;
            case ch.ergon.adam.core.db.schema.DataType.DECIMAL -> SQLDataType.DECIMAL;
            case ch.ergon.adam.core.db.schema.DataType.DATE -> SQLDataType.DATE;
            case ch.ergon.adam.core.db.schema.DataType.TIMESTAMP -> SQLDataType.TIMESTAMP;
            case ch.ergon.adam.core.db.schema.DataType.TIME -> SQLDataType.TIME;
            case ch.ergon.adam.core.db.schema.DataType.INTERVALYEARTOSECOND -> SQLDataType.INTERVAL;
            case ch.ergon.adam.core.db.schema.DataType.INTERVALYEARTOMONTH -> SQLDataType.INTERVALYEARTOMONTH;
            case ch.ergon.adam.core.db.schema.DataType.INTERVALDAYTOSECOND -> SQLDataType.INTERVALDAYTOSECOND;
            case ch.ergon.adam.core.db.schema.DataType.LOCALDATE -> SQLDataType.LOCALDATE;
            case ch.ergon.adam.core.db.schema.DataType.LOCALTIME -> SQLDataType.LOCALTIME;
            case ch.ergon.adam.core.db.schema.DataType.LOCALDATETIME -> SQLDataType.LOCALDATETIME;
            case ch.ergon.adam.core.db.schema.DataType.OFFSETTIME -> SQLDataType.OFFSETTIME;
            case ch.ergon.adam.core.db.schema.DataType.OFFSETDATETIME -> SQLDataType.OFFSETDATETIME;
            case ch.ergon.adam.core.db.schema.DataType.TIMEWITHTIMEZONE -> SQLDataType.TIMEWITHTIMEZONE;
            case ch.ergon.adam.core.db.schema.DataType.TIMESTAMPWITHTIMEZONE -> SQLDataType.TIMESTAMPWITHTIMEZONE;
            case ch.ergon.adam.core.db.schema.DataType.BINARY -> SQLDataType.BINARY;
            case ch.ergon.adam.core.db.schema.DataType.VARBINARY -> SQLDataType.VARBINARY;
            case ch.ergon.adam.core.db.schema.DataType.LONGVARBINARY -> SQLDataType.LONGVARBINARY;
            case ch.ergon.adam.core.db.schema.DataType.BLOB -> SQLDataType.BLOB;
            case ch.ergon.adam.core.db.schema.DataType.UUID -> SQLDataType.UUID;
            default -> throw new RuntimeException("Unsupported datatype [" + String.valueOf(type) + "]");
        }).getDataType(this.context.configuration());
    }
}

