/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.jooq;

import ch.ergon.adam.core.db.interfaces.SqlExecutor;
import ch.ergon.adam.jooq.JooqUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.jooq.CloseableDSLContext;
import org.jooq.DSLContext;
import org.jooq.Result;
import org.jooq.impl.DSL;

public class JooqSqlExecutor
implements SqlExecutor {
    protected final DSLContext context;
    private final String schema;
    private final Connection connection;

    public JooqSqlExecutor(String url, String schema) {
        this.context = DSL.using((String)url);
        this.schema = schema;
        this.connection = null;
    }

    public JooqSqlExecutor(Connection dbConnection, String schema) {
        this.context = DSL.using((Connection)dbConnection);
        this.schema = schema;
        this.connection = dbConnection;
    }

    public void close() {
        if (this.context instanceof CloseableDSLContext) {
            ((CloseableDSLContext)this.context).close();
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void executeScript(String script) {
        this.context.execute(script);
    }

    public Object queryResult(String query, Object ... params) {
        Result result = this.context.resultQuery(JooqUtils.ensureCorrectEscaping(query, this.context.dialect()), params).fetch();
        if (result.isNotEmpty()) {
            return result.getValue(0, 0);
        }
        return null;
    }

    public void rollback() {
    }

    public void dropSchema() {
        this.context.dropSchema(this.schema).cascade().execute();
    }
}

