/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.oracle;

import ch.ergon.adam.core.db.schema.Constraint;
import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.PrimaryKeyConstraint;
import ch.ergon.adam.core.db.schema.RuleConstraint;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.jooq.JooqSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;

public class OracleSqlSource
extends JooqSource {
    private final String schemaName;
    private Map<String, DbEnum> enums;

    public OracleSqlSource(String url, String schemaName) throws SQLException {
        super(url, schemaName);
        this.schemaName = schemaName;
        this.setSqlDialect(SQLDialect.ORACLE18C);
    }

    public OracleSqlSource(Connection connection, String schemaName) {
        super(connection, schemaName);
        this.setSqlDialect(SQLDialect.ORACLE18C);
        this.schemaName = schemaName;
    }

    public Schema getSchema() {
        Schema schema = super.getSchema();
        this.fetchConstraints(schema);
        return schema;
    }

    protected String getViewDefinition(String name) {
        Result result = this.getContext().resultQuery("select TEXT from SYS.USER_VIEWS where VIEW_NAME = ?", new Object[]{name}).fetch();
        return ((Record)result.getFirst()).getValue("TEXT").toString();
    }

    protected Map<String, List<String>> fetchViewDependencies() {
        Result result = this.getContext().resultQuery("  SELECT NAME AS owner, REFERENCED_NAME AS base\n  FROM SYS.ALL_DEPENDENCIES\n  WHERE TYPE = 'VIEW' AND REFERENCED_TYPE  IN ('VIEW', 'TABLE')\n  AND OWNER = ?\n  AND REFERENCED_OWNER = OWNER\n", new Object[]{this.schemaName}).fetch();
        return result.stream().collect(Collectors.groupingBy(r -> r.getValue("OWNER").toString(), Collectors.mapping(r -> r.getValue("BASE").toString(), Collectors.toList())));
    }

    private void fetchConstraints(Schema schema) {
        Result result = this.getContext().resultQuery("SELECT CONSTRAINT_NAME, CONSTRAINT_TYPE, TABLE_NAME, SEARCH_CONDITION FROM ALL_CONSTRAINTS WHERE OWNER = ?\nAND SEARCH_CONDITION_VC not like ('\"%\" IS NOT NULL')\n", new Object[]{this.schemaName}).fetch();
        Map byTable = result.stream().filter(r -> schema.getTable(r.getValue("TABLE_NAME").toString()) != null).collect(Collectors.groupingBy(r -> schema.getTable(r.getValue("TABLE_NAME").toString()), Collectors.toList()));
        byTable.keySet().forEach(table -> table.setConstraints(((List)byTable.get(table)).stream().map(this::mapConstraintFromOracle).collect(Collectors.toList())));
    }

    private Constraint mapConstraintFromOracle(Record record) {
        String constraintType = record.getValue("CONSTRAINT_TYPE").toString();
        String name = record.getValue("CONSTRAINT_NAME").toString();
        if (this.isGeneratedName(name)) {
            name = null;
        }
        switch (constraintType) {
            case "P": {
                return new PrimaryKeyConstraint(name);
            }
            case "C": {
                RuleConstraint ruleConstraint = new RuleConstraint(name);
                String expression = record.getValue("SEARCH_CONDITION").toString();
                ruleConstraint.setRule(expression);
                return ruleConstraint;
            }
        }
        throw new RuntimeException(String.format("Unsupported constraint type [%s]", constraintType));
    }

    protected boolean isGeneratedName(String name) {
        return name.startsWith("SYS_");
    }

    protected Field mapFieldFromJooq(org.jooq.Field<?> jooqField) {
        Field field = super.mapFieldFromJooq(jooqField);
        if (field.getDataType() == DataType.DECIMAL_INTEGER && field.getPrecision() == 19) {
            field.setPrecision(null);
            field.setDataType(DataType.BIGINT);
        }
        return field;
    }
}

