package ch.ergon.adam.oracle;

import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.jooq.JooqSink;

import java.sql.Connection;

import static java.lang.String.format;
import static org.jooq.SQLDialect.ORACLE18C;

public class OracleSqlSink extends JooqSink {

    private String schemaName;

    public OracleSqlSink(Connection dbConnection, String schema) {
        super(dbConnection, ORACLE18C, schema);
        this.schemaName = schema;
    }

    @Override
    public void dropSequencesAndDefaults(Table table) {
        //TODO: implement drop of sequences
    }

    @Override
    public void adjustSequences(Table table) {
        table.getFields().stream()
            .filter(Field::isSequence)
            .forEach(this::adjustSequence);
    }

    private void adjustSequence(Field field) {
        Long nextValue = context.resultQuery(format("SELECT NVL(max(\"%s\"), 0) + 1 FROM \"%s\"", field.getName(), field.getTable().getName())).fetchSingle(0, Long.class);;
        context.query(format("alter table \"%s\" modify \"%s\" generated by default on null as identity(start with %d)", field.getTable().getName(), field.getName(), nextValue)).execute();
    }
}
