/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.oracle;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleScriptParser {
    Pattern COMMENT_PATTERN = Pattern.compile("/\\*.*?\\*/");
    private final List<String> script;
    private String statementSoFar;
    private int lineNo;
    private int statementLineNo;
    private List<SqlStatement> result;

    public OracleScriptParser(String sourceScript) {
        this.script = Arrays.asList(sourceScript.split("\n"));
    }

    public List<SqlStatement> parse() {
        this.resetParser();
        for (String line : this.script) {
            ++this.lineNo;
            String normalizedLine = line.trim().toLowerCase();
            if (normalizedLine.startsWith("--")) continue;
            if (line.equals("/") || line.equals(";")) {
                this.recognizeTerminator();
                continue;
            }
            this.recognizeSqlLine(line);
        }
        this.recognizeTerminator();
        return this.result;
    }

    private void resetParser() {
        this.result = new LinkedList<SqlStatement>();
        this.statementSoFar = "";
        this.lineNo = 0;
        this.statementLineNo = 0;
    }

    private void recognizeTerminator() {
        String sql = this.stripSemicolonIfRequired(this.statementSoFar);
        this.statementSoFar = "";
        if (!this.stripComments(sql).isEmpty()) {
            this.result.add(new SqlStatement(sql, this.statementLineNo));
        }
    }

    private String stripSemicolonIfRequired(String sql) {
        if ((sql = sql.trim()).endsWith(";") && !sql.toLowerCase().endsWith("end;")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    private String stripComments(String sql) {
        Matcher matcher = this.COMMENT_PATTERN.matcher(sql);
        return matcher.replaceAll("").trim();
    }

    private void recognizeSqlLine(String line) {
        if (this.statementSoFar == "") {
            this.statementLineNo = this.lineNo;
        }
        this.statementSoFar = this.statementSoFar + line + System.lineSeparator();
    }

    public record SqlStatement(String statement, int lineNo) {
    }
}

