/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.oracle;

import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.jooq.JooqSink;
import java.sql.Connection;
import org.jooq.SQLDialect;

public class OracleSqlSink
extends JooqSink {
    private String schemaName;

    public OracleSqlSink(Connection dbConnection, String schema) {
        super(dbConnection, SQLDialect.ORACLE18C, schema);
        this.schemaName = schema;
    }

    public void dropSequencesAndDefaults(Table table) {
    }

    public void adjustSequences(Table table) {
        table.getFields().stream().filter(Field::isSequence).forEach(this::adjustSequence);
    }

    private void adjustSequence(Field field) {
        Long nextValue = (Long)this.context.resultQuery(String.format("SELECT NVL(max(\"%s\"), 0) + 1 FROM \"%s\"", field.getName(), field.getTable().getName())).fetchSingle(0, Long.class);
        this.context.query(String.format("alter table \"%s\" modify \"%s\" generated by default on null as identity(start with %d)", field.getTable().getName(), field.getName(), nextValue)).execute();
    }
}

