/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.oracle;

import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.interfaces.SchemaSource;
import ch.ergon.adam.core.db.interfaces.SqlExecutor;
import ch.ergon.adam.core.db.schema.Constraint;
import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.jooq.JooqSqlExecutor;
import ch.ergon.adam.oracle.OracleSqlExecutor;
import ch.ergon.adam.oracle.OracleSqlSink;
import ch.ergon.adam.oracle.OracleSqlSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSqlTransactionWrapper
implements SchemaSource,
SchemaSink,
SqlExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OracleSqlTransactionWrapper.class);
    private final Connection dbConnection;
    private final Runnable closeHandler;
    JooqSqlExecutor sqlExecutor;
    OracleSqlSink sqlSink;
    OracleSqlSource sqlSource;
    private boolean closed;
    private int clientCount = 0;

    public OracleSqlTransactionWrapper(String url, String schema, Runnable closeHandler) {
        this.closeHandler = closeHandler;
        try {
            this.dbConnection = DriverManager.getConnection(url);
            this.sqlSink = new OracleSqlSink(this.dbConnection, schema);
            this.sqlSource = new OracleSqlSource(this.dbConnection, schema);
            this.beginTransaction();
            this.sqlExecutor = new OracleSqlExecutor(this.dbConnection, schema);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void increaseClientCount() {
        ++this.clientCount;
    }

    public void decreaseClientCount() {
        --this.clientCount;
    }

    public int getClientCount() {
        return this.clientCount;
    }

    public void beginTransaction() {
        try {
            this.dbConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void commitTransaction() {
        try {
            logger.info("Doing a commit of the changes.");
            this.dbConnection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void rollbackTransaction() {
        try {
            if (this.dbConnection.isClosed()) {
                return;
            }
            logger.info("Doing a rollback of the changes.");
            this.dbConnection.rollback();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTargetSchema(Schema targetSchema) {
        this.sqlSink.setTargetSchema(targetSchema);
    }

    public void commitChanges() {
        this.sqlSink.commitChanges();
    }

    public void rollback() {
        this.rollbackTransaction();
    }

    public void dropForeignKey(ForeignKey foreignKey) {
        this.sqlSink.dropForeignKey(foreignKey);
    }

    public void createForeignKey(ForeignKey foreignKey) {
        this.sqlSink.createForeignKey(foreignKey);
    }

    public void dropIndex(Index index) {
        this.sqlSink.dropIndex(index);
    }

    public void createIndex(Index index) {
        this.sqlSink.createIndex(index);
    }

    public void addField(Field field) {
        this.sqlSink.addField(field);
    }

    public void dropField(Field field, Table table) {
        this.sqlSink.dropField(field, table);
    }

    public void setDefault(Field field) {
        this.sqlSink.setDefault(field);
    }

    public void dropDefault(Field field) {
        this.sqlSink.dropDefault(field);
    }

    public void createTable(Table table) {
        this.sqlSink.createTable(table);
    }

    public void dropTable(Table table) {
        this.sqlSink.dropTable(table);
    }

    public void renameTable(Table oldTable, String targetTableName) {
        this.sqlSink.renameTable(oldTable, targetTableName);
    }

    public void copyData(Table sourceTable, Table targetTable, String sourceTableName) {
        this.sqlSink.copyData(sourceTable, targetTable, sourceTableName);
    }

    public void createView(View view) {
        this.sqlSink.createView(view);
    }

    public void dropView(View view) {
        this.sqlSink.dropView(view);
    }

    public void dropEnum(DbEnum dbEnum) {
        this.sqlSink.dropEnum(dbEnum);
    }

    public void createEnum(DbEnum dbEnum) {
        this.sqlSink.createEnum(dbEnum);
    }

    public void changeFieldType(Field oldField, Field newField, DataType targetDataType) {
        this.sqlSink.changeFieldType(oldField, newField, targetDataType);
    }

    public void dropConstraint(Constraint constraint) {
        this.sqlSink.dropConstraint(constraint);
    }

    public void createConstraint(Constraint constraint) {
        this.sqlSink.createConstraint(constraint);
    }

    public void dropSequence(Sequence sequence) {
        this.sqlSink.dropSequence(sequence);
    }

    public void createSequence(Sequence sequence) {
        this.sqlSink.createSequence(sequence);
    }

    public void dropSequencesAndDefaults(Table table) {
        this.sqlSink.dropSequencesAndDefaults(table);
    }

    public void adjustSequences(Table table) {
        this.sqlSink.adjustSequences(table);
    }

    public void executeScript(String script) {
        this.sqlExecutor.executeScript(script);
    }

    public Object queryResult(String query, Object ... params) {
        return this.sqlExecutor.queryResult(query, params);
    }

    public void dropSchema() {
        this.sqlExecutor.dropSchema();
    }

    public void close() {
        this.closeHandler.run();
    }

    public void reallyClose() {
        this.closed = true;
        try {
            if (!this.dbConnection.getAutoCommit()) {
                this.commitTransaction();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.sqlExecutor.close();
        this.sqlSink.close();
        this.sqlSource.close();
        try {
            this.dbConnection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean supportAlterAndDropField() {
        return this.sqlSink.supportAlterAndDropField();
    }

    public Schema getSchema() {
        return this.sqlSource.getSchema();
    }

    public Connection getConnection() {
        return this.dbConnection;
    }
}

