/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.postgresql;

import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.helper.CollectorsHelper;
import ch.ergon.adam.jooq.JooqSink;
import java.sql.Connection;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.QueryPart;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;

public class PostgreSqlSink
extends JooqSink {
    private String schemaName;

    public PostgreSqlSink(Connection dbConnection, String schema) {
        super(dbConnection, SQLDialect.POSTGRES, schema);
        this.schemaName = schema;
    }

    public void dropEnum(DbEnum dbEnum) {
        this.context.execute(String.format("DROP TYPE \"%s\"", dbEnum.getName()));
    }

    public void createEnum(DbEnum dbEnum) {
        this.context.execute(String.format("CREATE TYPE \"%s\" AS ENUM (%s)", dbEnum.getName(), CollectorsHelper.createQuotedList((String[])dbEnum.getValues(), (String)"'")));
    }

    public void changeFieldType(Field oldField, Field newField, ch.ergon.adam.core.db.schema.DataType targetDataType) {
        String newTypeName;
        String using = "";
        if (targetDataType == ch.ergon.adam.core.db.schema.DataType.ENUM) {
            using = String.format(" USING %s::%s", newField.getName(), newField.getDbEnum().getName());
            newTypeName = this.mapType(newField).getTypeName();
            if (newField.isArray()) {
                newTypeName = newTypeName + "[]";
                using = using + "[]";
            }
        } else {
            newTypeName = this.mapRawType(targetDataType).getTypeName();
        }
        this.context.execute(String.format("ALTER TABLE \"%s\" ALTER COLUMN \"%s\" TYPE %s%s", oldField.getTable().getName(), oldField.getName(), newTypeName, using));
    }

    protected DataType<?> mapType(Field field) {
        if (field.isSequence()) {
            if (field.getDataType() == ch.ergon.adam.core.db.schema.DataType.BIGINT) {
                return new DefaultDataType(null, SQLDataType.BIGINT, "bigserial", "bigserial").nullable(false);
            }
            return new DefaultDataType(null, SQLDataType.INTEGER, "serial", "serial").nullable(false);
        }
        return super.mapType(field);
    }

    protected DataType<?> mapFieldToJooqType(Field field) {
        switch (field.getDataType()) {
            case ENUM: {
                DefaultDataType jooqType = new DefaultDataType(null, SQLDataType.VARCHAR, field.getDbEnum().getName(), field.getDbEnum().getName());
                return jooqType;
            }
        }
        return super.mapFieldToJooqType(field);
    }

    public void copyData(Table sourceTable, Table targetTable, String sourceTableName) {
        super.copyData(sourceTable, targetTable, sourceTableName);
        targetTable.getFields().stream().filter(Field::isSequence).forEach(sequenceField -> {
            String sequenceName = this.context.fetch(String.format("select pg_get_serial_sequence('%s','%s')", targetTable.getName(), sequenceField.getName())).getValue(0, 0).toString();
            this.context.execute(String.format("BEGIN;\n-- protect against concurrent inserts while you update the counter\nLOCK TABLE \"%s\" IN EXCLUSIVE MODE;\n-- Update the sequence\nSELECT setval('%s',(SELECT GREATEST(MAX(\"%s\")+1,nextval('%s'))-1 FROM \"%s\")) where exists (select 1 from \"%s\");\nCOMMIT;", targetTable.getName(), sequenceName, sequenceField.getName(), sequenceName, targetTable.getName(), targetTable.getName()));
        });
    }

    protected String castIfNeeded(Field sourceField, Field targetField, DSLContext renderContext) {
        if (targetField.getDataType() == ch.ergon.adam.core.db.schema.DataType.ENUM && sourceField.getDataType() == ch.ergon.adam.core.db.schema.DataType.ENUM && !sourceField.getDbEnum().getName().equals(targetField.getDbEnum().getName())) {
            DataType<?> targetType = this.mapType(targetField);
            org.jooq.Field jooqField = DSL.field((String)("\"" + targetField.getName() + "\""));
            DefaultDataType varCharType = new DefaultDataType(null, SQLDataType.VARCHAR, "VARCHAR");
            return renderContext.render((QueryPart)DSL.cast((org.jooq.Field)DSL.cast((org.jooq.Field)jooqField, (DataType)varCharType), targetType));
        }
        if (targetField.getDataType() != sourceField.getDataType() && targetField.isSequence()) {
            DataType targetType = this.mapType(targetField).getSQLDataType();
            org.jooq.Field jooqField = DSL.field((String)("\"" + targetField.getName() + "\""));
            return String.format("cast(%s as %s)", jooqField.toString(), targetType.getCastTypeName());
        }
        return super.castIfNeeded(sourceField, targetField, renderContext);
    }

    public void dropSequencesAndDefaults(Table table) {
        super.dropSequencesAndDefaults(table);
        Result result = this.context.resultQuery("        SELECT\n        seq_class.relname\n            FROM\n        pg_class seq_class\n        join pg_depend depend on (seq_class.oid = depend.objid)\n        join pg_class table_class on (table_class.oid = depend.refobjid)\n        join pg_namespace ns on (table_class.relnamespace = ns.oid)\n        WHERE\n        seq_class.relkind = 'S' and\n        table_class.relkind = 'r' and\n        table_class.relname = ? and\n        ns.nspname=?;", new Object[]{table.getName(), this.schemaName}).fetch();
        result.forEach(row -> this.dropSequence(new Sequence((String)row.getValue(0, String.class))));
    }

    public void dropSequence(Sequence sequence) {
        this.context.execute("drop sequence " + sequence.getName() + " cascade");
    }
}

