/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.postgresql;

import ch.ergon.adam.core.db.schema.Constraint;
import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.PrimaryKeyConstraint;
import ch.ergon.adam.core.db.schema.Relation;
import ch.ergon.adam.core.db.schema.RuleConstraint;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.helper.CollectorsHelper;
import ch.ergon.adam.jooq.JooqSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;

public class PostgreSqlSource
extends JooqSource {
    private static final Pattern CHECK_CONSTRAINT_PATTERN = Pattern.compile("^CHECK \\((.*)\\)$");
    private static final Pattern DEFAULT_CAST_PATTERN = Pattern.compile("cast\\((.*) as [^ ^)]+( array)?\\)");
    private final String schemaName;
    private Map<String, DbEnum> enums;

    public PostgreSqlSource(String url, String schemaName) throws SQLException {
        super(url, schemaName);
        this.schemaName = schemaName;
        this.setSqlDialect(SQLDialect.POSTGRES);
    }

    public PostgreSqlSource(Connection connection, String schemaName) {
        super(connection, schemaName);
        this.setSqlDialect(SQLDialect.POSTGRES);
        this.schemaName = schemaName;
    }

    public Schema getSchema() {
        this.enums = (Map)this.getEnums().stream().collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        Schema schema = super.getSchema();
        schema.setSequences(this.getSequences());
        schema.setEnums(this.enums.values());
        this.setCustomTypes(schema);
        this.fetchConstraints(schema);
        return schema;
    }

    protected String getDefaultValue(Field<?> jooqField) {
        String defaultValue = super.getDefaultValue(jooqField);
        if (defaultValue == null) {
            return null;
        }
        Matcher matcher = DEFAULT_CAST_PATTERN.matcher(defaultValue);
        defaultValue = matcher.replaceAll(r -> r.group(1));
        return defaultValue;
    }

    protected Map<String, List<String>> fetchViewDependencies() {
        Result result = this.getContext().resultQuery("SELECT cl_r.relname AS view, cl_d.relname AS base FROM pg_rewrite AS r JOIN pg_class AS cl_r ON r.ev_class=cl_r.oid JOIN pg_depend AS d ON r.oid = d.objid JOIN pg_class AS cl_d ON d.refobjid = cl_d.oid JOIN pg_namespace AS ns ON cl_d.relnamespace = ns.oid AND ns.oid = cl_r.relnamespace WHERE cl_d.relkind IN ('v', 'r') and cl_r.relname != cl_d.relname AND ns.nspname = ? GROUP BY cl_r.relname, cl_d.relname, cl_d.relkind", new Object[]{this.schemaName}).fetch();
        return result.stream().collect(Collectors.groupingBy(r -> r.getValue("view").toString(), Collectors.mapping(r -> r.getValue("base").toString(), Collectors.toList())));
    }

    private void setCustomTypes(Schema schema) {
        Result result = this.getContext().resultQuery("SELECT table_name, column_name, udt_name, is_nullable, data_type FROM information_schema.columns WHERE udt_name IS NOT NULL AND udt_schema = ?", new Object[]{this.schemaName}).fetch();
        for (Record record : result) {
            Relation relation = schema.getRelation(record.getValue("table_name").toString());
            if (relation == null) continue;
            ch.ergon.adam.core.db.schema.Field field = relation.getField(record.getValue("column_name").toString());
            String udtName = record.getValue("udt_name").toString();
            if ("ARRAY".equals(record.getValue("data_type"))) {
                field.setArray(true);
                if (udtName.startsWith("_")) {
                    udtName = udtName.substring(1);
                }
            }
            DbEnum dbEnum = Objects.requireNonNull(schema.getEnum(udtName), "Unknown udt name [" + udtName + "] for field [" + field.getName() + "] on table [" + relation.getName() + "].");
            boolean isNullable = record.getValue("is_nullable").toString().toLowerCase().equals("yes");
            field.setDataType(DataType.ENUM);
            field.setDbEnum(dbEnum);
            field.setNullable(isNullable);
        }
    }

    private Collection<DbEnum> getEnums() {
        Result result = this.getContext().resultQuery("SELECT t.typname, string_agg(e.enumlabel, '|' ORDER BY e.enumsortorder) AS enum_labels FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace JOIN pg_catalog.pg_enum e ON t.oid = e.enumtypid WHERE n.nspname = ? GROUP BY typname;", new Object[]{this.schemaName}).fetch();
        return result.stream().map(this::mapEnumFromPostgres).sorted(Comparator.comparing(SchemaItem::getName)).collect(Collectors.toList());
    }

    private Collection<Sequence> getSequences() {
        Result result = this.getContext().resultQuery("SELECT sequence_name, start_value, minimum_value, maximum_value, increment FROM information_schema.sequences where sequence_schema = ? and sequence_name in ( select seq.relname from pg_class as seq JOIN pg_namespace AS ns ON seq.relnamespace = ns.oid where ns.nspname = ? and seq.relkind='S' and seq.relfilenode not in (select dep.objid from pg_depend dep join pg_class as tab on (dep.refobjid = tab.oid)))", new Object[]{this.schemaName, this.schemaName}).fetch();
        return result.stream().map(this::mapSequenceFromPostgres).sorted(Comparator.comparing(SchemaItem::getName)).collect(Collectors.toList());
    }

    private Sequence mapSequenceFromPostgres(Record record) {
        Sequence sequence = new Sequence(record.getValue("sequence_name").toString());
        sequence.setStartValue(Long.valueOf(record.getValue("start_value").toString()));
        sequence.setMinValue(Long.valueOf(record.getValue("minimum_value").toString()));
        sequence.setMaxValue(Long.valueOf(record.getValue("maximum_value").toString()));
        sequence.setIncrement(Long.valueOf(record.getValue("increment").toString()));
        return sequence;
    }

    private void fetchConstraints(Schema schema) {
        Result result = this.getContext().resultQuery("SELECT rel.relname, con.conname, con.contype, pg_get_constraintdef(con.oid) AS expression FROM pg_catalog.pg_constraint con INNER JOIN pg_catalog.pg_class rel ON rel.oid = con.conrelid INNER JOIN pg_catalog.pg_namespace nsp ON nsp.oid = connamespace WHERE con.contype IN ('c', 'p') AND nsp.nspname = ?", new Object[]{this.schemaName}).fetch();
        Map byTable = result.stream().collect(Collectors.groupingBy(record -> schema.getTable(record.getValue("relname").toString()), Collectors.toList()));
        byTable.keySet().forEach(table -> table.setConstraints(((List)byTable.get(table)).stream().map(this::mapConstraintFromPostgres).collect(Collectors.toList())));
    }

    private Constraint mapConstraintFromPostgres(Record record) {
        String constraintType = record.getValue("contype").toString();
        String name = record.getValue("conname").toString();
        switch (constraintType) {
            case "p": {
                return new PrimaryKeyConstraint(name);
            }
            case "c": {
                RuleConstraint ruleConstraint = new RuleConstraint(name);
                String expression = record.getValue("expression").toString();
                Matcher matcher = CHECK_CONSTRAINT_PATTERN.matcher(expression);
                if (!matcher.find()) {
                    throw new RuntimeException(String.format("Rule [%s] for constraint [%s] could not be parsed.", expression, name));
                }
                ruleConstraint.setRule(matcher.group(1));
                return ruleConstraint;
            }
        }
        throw new RuntimeException(String.format("Unsupported constraint type [%s]", constraintType));
    }

    private DbEnum mapEnumFromPostgres(Record record) {
        DbEnum dbEnum = new DbEnum(record.getValue(0).toString());
        dbEnum.setValues(record.getValue(1).toString().split("\\|"));
        return dbEnum;
    }

    protected String getViewDefinition(String name) {
        Result result = this.getContext().resultQuery("select view_definition from INFORMATION_SCHEMA.views where table_schema = ? and table_name = ?", new Object[]{this.schemaName, name}).fetch();
        return ((Record)result.getFirst()).getValue("view_definition").toString();
    }

    protected DataType mapDataTypeFromJooq(Field<?> jooqField) {
        String typeName;
        switch (typeName = jooqField.getDataType().isArray() ? jooqField.getDataType().getArrayComponentDataType().getTypeName() : jooqField.getDataType().getTypeName()) {
            case "other": {
                return null;
            }
            case "text": {
                return DataType.CLOB;
            }
        }
        if (this.enums.containsKey(typeName) || this.enums.containsKey(typeName.replaceFirst("_", ""))) {
            return DataType.ENUM;
        }
        return super.mapDataTypeFromJooq(jooqField);
    }
}

