/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.sqlite;

import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.interfaces.SchemaSource;
import ch.ergon.adam.core.db.interfaces.SourceAndSinkAdapter;
import ch.ergon.adam.core.db.interfaces.SqlExecutor;
import ch.ergon.adam.jooq.JooqSqlExecutor;
import ch.ergon.adam.sqlite.SqliteInMemoryFactory;
import ch.ergon.adam.sqlite.SqliteSink;
import ch.ergon.adam.sqlite.SqliteSource;
import java.sql.SQLException;

public class SqliteFactory
implements SourceAndSinkAdapter {
    public boolean supportsUrl(String url) {
        return url.toLowerCase().startsWith("jdbc:sqlite:") && !url.toLowerCase().startsWith(SqliteInMemoryFactory.SQLITE_IN_MEMORY_URL);
    }

    public SchemaSource createSource(String url) {
        try {
            return new SqliteSource(url);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public SchemaSink createSink(String url) {
        return new SqliteSink(url);
    }

    public SqlExecutor createSqlExecutor(String url) {
        return new JooqSqlExecutor(url, null);
    }
}

