/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.sqlite;

import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.jooq.JooqSink;
import java.sql.Connection;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jooq.CreateIndexStep;
import org.jooq.SQLDialect;

public class SqliteSink
extends JooqSink {
    public SqliteSink(String url) {
        super(url);
    }

    public SqliteSink(Connection connection) {
        super(connection, SQLDialect.SQLITE);
    }

    public void createIndex(Index index) {
        if (index.isPrimary()) {
            return;
        }
        if (index.getName().toLowerCase().startsWith("sqlite_")) {
            Collection fieldNames = index.getFields().stream().map(arg_0 -> ((SqliteSink)this).getFieldName(arg_0)).collect(Collectors.toList());
            CreateIndexStep createIndex = index.isUnique() ? this.context.createUniqueIndex() : this.context.createIndex();
            createIndex.on(this.getTableName(index.getTable()), fieldNames).execute();
        } else {
            super.createIndex(index);
        }
    }

    public boolean supportAlterAndDropField() {
        return false;
    }
}

