/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.sqlite;

import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.jooq.JooqSource;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;

public class SqliteSource
extends JooqSource {
    public SqliteSource(String url) throws SQLException {
        super(url);
        this.setSqlDialect(SQLDialect.SQLITE);
    }

    public SqliteSource(Connection connection) {
        super(connection);
        this.setSqlDialect(SQLDialect.SQLITE);
    }

    public Schema getSchema() {
        Schema schema = super.getSchema();
        schema.setViews(this.getViews());
        schema.getViews().forEach(view -> view.setFields(schema.getTable(view.getName()).getFields()));
        schema.getTables().removeIf(table -> schema.getView(table.getName()) != null);
        this.setPrimaryKeys(schema);
        this.setSequences(schema);
        return schema;
    }

    private Collection<View> getViews() {
        Result result = this.getContext().resultQuery("select name, sql from sqlite_master where type = 'view'").fetch();
        return result.stream().map(this::mapViewFromJooq).sorted(Comparator.comparing(SchemaItem::getName)).collect(Collectors.toList());
    }

    private View mapViewFromJooq(Record record) {
        String viewName = record.getValue("name").toString();
        String viewDefinition = record.getValue("sql").toString();
        viewDefinition = viewDefinition.replaceAll("^(?i)create view [^ ]+ as ", "");
        View view = new View(viewName);
        view.setViewDefinition(viewDefinition);
        return view;
    }

    private void setPrimaryKeys(Schema schema) {
        block0: for (Table table : schema.getTables()) {
            Result result = this.getContext().resultQuery("PRAGMA table_info('test_table')").fetch();
            for (Record record : result) {
                if ((Integer)record.getValue("pk", Integer.class) == 0) continue;
                String fieldName = (String)record.getValue("name", String.class);
                Index primaryKeyIndex = new Index("pk");
                primaryKeyIndex.setPrimary(true);
                primaryKeyIndex.setUnique(true);
                primaryKeyIndex.setFields((List)Lists.newArrayList((Object[])new Field[]{table.getField(fieldName)}));
                ArrayList newIndexList = Lists.newArrayList((Object[])new Index[]{primaryKeyIndex});
                newIndexList.addAll(table.getIndexes());
                table.setIndexes((List)newIndexList);
                continue block0;
            }
        }
    }

    private void setSequences(Schema schema) {
        Result result = this.getContext().resultQuery("SELECT tbl_name FROM sqlite_master WHERE sql LIKE \"%AUTOINCREMENT%\"").fetch();
        result.forEach(record -> {
            String tableName = (String)record.getValue("tbl_name", String.class);
            Table table = schema.getTable(tableName);
            table.getIndexes().forEach(index -> {
                if (index.isPrimary()) {
                    index.getFields().forEach(field -> field.setSequence(true));
                }
            });
        });
    }
}

