/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.yml;

import ch.ergon.adam.core.db.interfaces.SchemaSource;
import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.RuleConstraint;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.SchemaItem;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.core.filetree.FileTreeTraverser;
import ch.ergon.adam.core.helper.CollectorsHelper;
import ch.ergon.adam.core.helper.Pair;
import ch.ergon.adam.yml.Helper;
import ch.ergon.adam.yml.schema.YmlEnum;
import ch.ergon.adam.yml.schema.YmlField;
import ch.ergon.adam.yml.schema.YmlForeignKey;
import ch.ergon.adam.yml.schema.YmlIndex;
import ch.ergon.adam.yml.schema.YmlRuleConstraint;
import ch.ergon.adam.yml.schema.YmlSequence;
import ch.ergon.adam.yml.schema.YmlTable;
import ch.ergon.adam.yml.schema.YmlView;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YmlSource
implements SchemaSource {
    private static final Logger logger = LoggerFactory.getLogger(YmlSequence.class);
    private static final String INDEX_NAME_PREFIX = "idx";
    private static final String RULE_NAME_PREFIX = "rule";
    private static final String FK_NAME_PREFIX = "fk";
    private final FileTreeTraverser fileTraverser;
    private final ObjectMapper mapper;

    public YmlSource(FileTreeTraverser fileTraverser) {
        this.fileTraverser = fileTraverser;
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    public Schema getSchema() {
        logger.info("Loading YML schema from [" + this.fileTraverser + "].");
        Schema schema = new Schema();
        schema.setEnums(this.loadEnums());
        schema.setSequences(this.loadSequences());
        List fileNames = this.fileTraverser.getFileNames();
        List tables = fileNames.stream().filter(fileName -> fileName.endsWith(".table.yml")).map(fileName -> this.loadTable((String)fileName, schema)).collect(Collectors.toList());
        List<YmlView> ymlViews = fileNames.stream().filter(fileName -> fileName.endsWith(".view.yml")).map(this::loadView).collect(Collectors.toList());
        Map tablesByName = (Map)tables.stream().map(Pair::getFirst).collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        tables.stream().map(Pair::getSecond).forEach(ymlTable -> this.setupForeignKeys((YmlTable)ymlTable, tablesByName));
        Map viewsByName = (Map)ymlViews.stream().map(this::mapFromYml).collect(CollectorsHelper.toLinkedMap(SchemaItem::getName, Function.identity()));
        schema.setTables(tablesByName.values());
        schema.setViews(viewsByName.values());
        ymlViews.forEach(ymlView -> this.setupViewDependencies((YmlView)ymlView, schema));
        return schema;
    }

    private void setupViewDependencies(YmlView ymlView, Schema schema) {
        View view = schema.getView(ymlView.getName());
        Arrays.stream(ymlView.getDependencies()).map(arg_0 -> ((Schema)schema).getRelation(arg_0)).forEach(arg_0 -> ((View)view).addBaseRelation(arg_0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Sequence> loadSequences() {
        try (InputStream inputStream = this.fileTraverser.openFile(Helper.getSequenceFileName());){
            if (inputStream == null) {
                LinkedList<Sequence> linkedList = new LinkedList<Sequence>();
                return linkedList;
            }
            YmlSequence[] ymlSequences = (YmlSequence[])this.mapper.readValue(inputStream, YmlSequence[].class);
            Collection collection = Arrays.stream(ymlSequences).map(this::mapFromYml).collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load table from file [" + Helper.getSequenceFileName() + "]", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<DbEnum> loadEnums() {
        try (InputStream inputStream = this.fileTraverser.openFile(Helper.getEnumFileName());){
            if (inputStream == null) {
                LinkedList<DbEnum> linkedList = new LinkedList<DbEnum>();
                return linkedList;
            }
            YmlEnum[] ymlEnums = (YmlEnum[])this.mapper.readValue(inputStream, YmlEnum[].class);
            Collection collection = Arrays.stream(ymlEnums).map(this::mapFromYml).collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load table from file [" + Helper.getEnumFileName() + "]", e);
        }
    }

    private void setupForeignKeys(YmlTable ymlTable, Map<String, Table> tablesByName) {
        Table table = tablesByName.get(ymlTable.getName());
        table.setForeignKeys(ymlTable.getForeignKeys().stream().map(ymlForeignKey -> this.mapFromYml((YmlForeignKey)ymlForeignKey, table, tablesByName, ymlTable.getForeignKeys().indexOf(ymlForeignKey))).collect(Collectors.toList()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<Table, YmlTable> loadTable(String fileName, Schema schema) {
        try (InputStream inputStream = this.fileTraverser.openFile(fileName);){
            YmlTable ymlTable = (YmlTable)this.mapper.readValue(inputStream, YmlTable.class);
            Pair pair = new Pair((Object)this.mapFromYml(ymlTable, schema), (Object)ymlTable);
            return pair;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load table from file [" + fileName + "]", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private YmlView loadView(String fileName) {
        try (InputStream inputStream = this.fileTraverser.openFile(fileName);){
            YmlView ymlView;
            YmlView ymlView2 = ymlView = (YmlView)this.mapper.readValue(inputStream, YmlView.class);
            return ymlView2;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load table from file [" + fileName + "]", e);
        }
    }

    private Sequence mapFromYml(YmlSequence ymlSequence) {
        Sequence sequence = new Sequence(ymlSequence.getName());
        sequence.setIncrement(ymlSequence.getIncrement());
        sequence.setMaxValue(ymlSequence.getMaxValue());
        sequence.setMinValue(ymlSequence.getMinValue());
        sequence.setStartValue(ymlSequence.getStartValue());
        return sequence;
    }

    private DbEnum mapFromYml(YmlEnum ymlEnum) {
        DbEnum dbEnum = new DbEnum(ymlEnum.getName());
        dbEnum.setValues(ymlEnum.getValues());
        return dbEnum;
    }

    private View mapFromYml(YmlView ymlView) {
        View view = new View(ymlView.getName());
        view.setViewDefinition(ymlView.getViewDefinition());
        return view;
    }

    private Table mapFromYml(YmlTable ymlTable, Schema schema) {
        Table table = new Table(ymlTable.getName());
        table.setFields((Collection)ymlTable.getFields().stream().map(ymlField -> this.mapFromYml((YmlField)ymlField, schema, table)).collect(Collectors.toList()));
        table.setIndexes(ymlTable.getIndexes().stream().map(ymlIndex -> this.mapFromYml((YmlIndex)ymlIndex, table, ymlTable.getIndexes().indexOf(ymlIndex))).collect(Collectors.toList()));
        table.setConstraints(ymlTable.getRuleConstraints().stream().map(ymlRule -> this.mapFromYml((YmlRuleConstraint)ymlRule, ymlTable, ymlTable.getRuleConstraints().indexOf(ymlRule))).collect(Collectors.toList()));
        table.setPreviousName(ymlTable.getPreviousName());
        return table;
    }

    private Field mapFromYml(YmlField ymlField, Schema schema, Table table) {
        Field field = new Field(ymlField.getName());
        field.setDataType(DataType.valueOf((String)ymlField.getDataType()));
        if (field.getDataType() == DataType.ENUM) {
            field.setDbEnum(Objects.requireNonNull(schema.getEnum(ymlField.getEnumName()), String.format("enum %s not found for field %s.%s", ymlField.getEnumName(), table.getName(), ymlField.getName())));
        }
        field.setNullable(ymlField.isNullable());
        field.setArray(ymlField.isArray());
        field.setDefaultValue(ymlField.getDefaultValue());
        field.setLength(ymlField.getLength());
        field.setPrecision(ymlField.getPrecision());
        field.setScale(ymlField.getScale());
        field.setSequence(ymlField.isSequence());
        field.setSqlForNew(ymlField.getSqlForNew());
        return field;
    }

    private Index mapFromYml(YmlIndex ymlIndex, Table table, int position) {
        String indexName = ymlIndex.getName();
        if (Strings.isNullOrEmpty((String)indexName)) {
            indexName = "idx_" + table.getName() + "_" + position;
        }
        Index index = new Index(indexName);
        index.setPrimary(ymlIndex.isPrimary());
        index.setUnique(ymlIndex.isPrimary() ? true : ymlIndex.isUnique());
        index.setWhere(ymlIndex.getWhere());
        index.setFields(Arrays.stream(ymlIndex.getFields()).map(name -> Objects.requireNonNull(table.getField(name), String.format("field %s.%s not found for index %s", table.getName(), name, ymlIndex.getName()))).collect(Collectors.toList()));
        return index;
    }

    private RuleConstraint mapFromYml(YmlRuleConstraint ymlRuleConstraint, YmlTable table, int position) {
        String name = ymlRuleConstraint.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            name = "rule_" + table.getName() + "_" + position;
        }
        RuleConstraint ruleConstraint = new RuleConstraint(name);
        ruleConstraint.setRule(ymlRuleConstraint.getRule());
        return ruleConstraint;
    }

    private ForeignKey mapFromYml(YmlForeignKey ymlForeignKey, Table table, Map<String, Table> tablesByName, int position) {
        String name = ymlForeignKey.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            name = "fk_" + table.getName() + "_" + position;
        }
        ForeignKey foreignKey = new ForeignKey(name);
        String foreignKeyName = table.getName() + "." + foreignKey.getName();
        foreignKey.setField(Objects.requireNonNull(table.getField(ymlForeignKey.getField()), String.format("field %s not found for foreign key %s", ymlForeignKey.getField(), foreignKeyName)));
        Table targetTable = Objects.requireNonNull(tablesByName.get(ymlForeignKey.getTargetTable()), String.format("table %s not found for foreign key %s", ymlForeignKey.getTargetTable(), foreignKeyName));
        if (Strings.isNullOrEmpty((String)ymlForeignKey.getTargetIndex())) {
            Index foreignPrimaryKey = targetTable.getIndexes().stream().filter(Index::isPrimary).findAny().orElseThrow(() -> new NullPointerException(String.format("targetIndex for foreign key on table %s not set and no primary key found on target table %s", table.getName(), targetTable.getName())));
            foreignKey.setTargetIndex(foreignPrimaryKey);
        } else {
            foreignKey.setTargetIndex(Objects.requireNonNull(targetTable.getIndex(ymlForeignKey.getTargetIndex()), String.format("index %s.%s not found for foreign key %s", ymlForeignKey.getTargetTable(), ymlForeignKey.getTargetIndex(), foreignKeyName)));
        }
        return foreignKey;
    }

    public void close() {
    }
}

