/*
 * Decompiled with CFR 0.152.
 */
package ch.ergon.adam.yml;

import ch.ergon.adam.core.db.interfaces.SchemaSink;
import ch.ergon.adam.core.db.schema.Constraint;
import ch.ergon.adam.core.db.schema.DataType;
import ch.ergon.adam.core.db.schema.DbEnum;
import ch.ergon.adam.core.db.schema.Field;
import ch.ergon.adam.core.db.schema.ForeignKey;
import ch.ergon.adam.core.db.schema.Index;
import ch.ergon.adam.core.db.schema.RuleConstraint;
import ch.ergon.adam.core.db.schema.Schema;
import ch.ergon.adam.core.db.schema.Sequence;
import ch.ergon.adam.core.db.schema.Table;
import ch.ergon.adam.core.db.schema.View;
import ch.ergon.adam.core.helper.CollectorsHelper;
import ch.ergon.adam.yml.Helper;
import ch.ergon.adam.yml.schema.YmlEnum;
import ch.ergon.adam.yml.schema.YmlField;
import ch.ergon.adam.yml.schema.YmlForeignKey;
import ch.ergon.adam.yml.schema.YmlIndex;
import ch.ergon.adam.yml.schema.YmlRuleConstraint;
import ch.ergon.adam.yml.schema.YmlSequence;
import ch.ergon.adam.yml.schema.YmlTable;
import ch.ergon.adam.yml.schema.YmlView;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class YmlSink
implements SchemaSink {
    private final File targetPath;
    private final OutputStream outputStream;
    private final ObjectMapper mapper;
    private Set<Table> updatedTables = new HashSet<Table>();
    private Set<Table> droppedTables = new HashSet<Table>();
    private Set<View> updatedViews = new HashSet<View>();
    private Set<View> droppedViews = new HashSet<View>();
    private Schema targetSchema;

    public YmlSink(File targetPath) {
        this.targetPath = targetPath;
        this.outputStream = null;
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    }

    public YmlSink(OutputStream outputStream) {
        this.targetPath = null;
        this.outputStream = outputStream;
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    }

    public void setTargetSchema(Schema targetSchema) {
        this.targetSchema = targetSchema;
    }

    public void commitChanges() {
        try {
            if (this.targetPath != null && !this.targetPath.exists()) {
                this.targetPath.mkdirs();
            }
            for (Table table : this.updatedTables) {
                this.writeTableToFile(table);
            }
            for (View view : this.updatedViews) {
                this.writeViewToFile(view);
            }
            this.writeEnumsToFile(this.targetSchema.getEnums());
            this.writeSequencesToFile(this.targetSchema.getSequences());
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            String target = this.targetPath != null ? this.targetPath.getAbsolutePath() : "outputstream";
            throw new RuntimeException("Failed to write schema to [" + target + "].", e);
        }
    }

    public void rollback() {
    }

    public void dropForeignKey(ForeignKey foreignKey) {
        this.updatedTables.add(this.mapToTargetTable(foreignKey.getTable()));
    }

    public void createForeignKey(ForeignKey foreignKey) {
        this.updatedTables.add(foreignKey.getTable());
    }

    public void dropIndex(Index index) {
        this.updatedTables.add(this.mapToTargetTable(index.getTable()));
    }

    public void createIndex(Index index) {
        this.updatedTables.add(index.getTable());
    }

    public void addField(Field field) {
        this.updatedTables.add(field.getTable());
    }

    public void dropField(Field field, Table table) {
        this.updatedTables.add(this.mapToTargetTable(table));
    }

    public void setDefault(Field field) {
        this.updatedTables.add(field.getTable());
    }

    public void dropDefault(Field field) {
        this.updatedTables.add(field.getTable());
    }

    public void createTable(Table table) {
        this.updatedTables.add(table);
    }

    public void dropTable(Table table) {
        this.droppedTables.add(table);
    }

    public void renameTable(Table oldTable, String newTableName) {
        if (this.targetSchema.getTable(newTableName) != null) {
            this.updatedTables.add(this.targetSchema.getTable(newTableName));
        }
        this.droppedTables.add(oldTable);
    }

    public void copyData(Table sourceTable, Table targetTable, String sourceTableName) {
    }

    public void createView(View view) {
        this.updatedViews.add(view);
    }

    public void dropView(View view) {
        this.droppedViews.add(view);
    }

    public void dropEnum(DbEnum dbEnum) {
    }

    public void createEnum(DbEnum dbEnum) {
    }

    public void changeFieldType(Field oldField, Field newField, DataType targetDataType) {
        this.updatedTables.add(newField.getTable());
    }

    public void dropConstraint(Constraint constraint) {
        this.updatedTables.add(this.mapToTargetTable(constraint.getTable()));
    }

    public void createConstraint(Constraint constraint) {
        this.updatedTables.add(constraint.getTable());
    }

    public void dropSequence(Sequence sequence) {
    }

    public void createSequence(Sequence sequence) {
    }

    public void dropSequencesAndDefaults(Table table) {
    }

    public void adjustSequences(Table table) {
    }

    private void writeTableToFile(Table table) throws IOException {
        YmlTable ymlTable = this.mapToYml(table);
        this.writeToFileOrStream(ymlTable, Helper.getTableFileName(table));
    }

    private void writeViewToFile(View view) throws IOException {
        YmlView ymlView = new YmlView(view.getName());
        ymlView.setViewDefinition(view.getViewDefinition());
        ymlView.setDependencies(CollectorsHelper.createSchemaItemNameArray((Collection)view.getBaseRelations()));
        this.writeToFileOrStream(ymlView, Helper.getViewFileName(view));
    }

    private void writeSequencesToFile(Collection<Sequence> sequences) throws IOException {
        List ymlSequences = sequences.stream().map(this::mapToYml).collect(Collectors.toList());
        this.writeToFileOrStream(ymlSequences, Helper.getSequenceFileName());
    }

    private void writeEnumsToFile(Collection<DbEnum> enums) throws IOException {
        List ymlEnums = enums.stream().map(this::mapToYml).collect(Collectors.toList());
        this.writeToFileOrStream(ymlEnums, Helper.getEnumFileName());
    }

    private void writeToFileOrStream(Object object, String fileName) throws IOException {
        if (this.targetPath != null) {
            File ymlFile = new File(this.targetPath, fileName);
            this.mapper.writeValue(ymlFile, object);
        } else {
            this.mapper.writeValue(this.outputStream, object);
        }
    }

    private YmlSequence mapToYml(Sequence sequence) {
        YmlSequence ymlSequence = new YmlSequence(sequence.getName());
        ymlSequence.setIncrement(sequence.getIncrement());
        ymlSequence.setMaxValue(sequence.getMaxValue());
        ymlSequence.setMinValue(sequence.getMinValue());
        ymlSequence.setStartValue(sequence.getStartValue());
        return ymlSequence;
    }

    private YmlEnum mapToYml(DbEnum dbEnum) {
        YmlEnum ymlEnum = new YmlEnum(dbEnum.getName());
        ymlEnum.setValues(dbEnum.getValues());
        return ymlEnum;
    }

    private YmlTable mapToYml(Table table) {
        YmlTable ymlTable = new YmlTable(table.getName());
        ymlTable.setFields(table.getFields().stream().map(this::mapToYml).collect(Collectors.toList()));
        ymlTable.setIndexes(table.getIndexes().stream().map(this::mapToYml).collect(Collectors.toList()));
        ymlTable.setForeignKeys(table.getForeignKeys().stream().map(this::mapToYml).collect(Collectors.toList()));
        ymlTable.setRuleConstraints(table.getConstraints().stream().filter(c -> c instanceof RuleConstraint).map(c -> (RuleConstraint)c).map(this::mapToYml).collect(Collectors.toList()));
        ymlTable.setPreviousName(table.getPreviousName());
        return ymlTable;
    }

    private YmlField mapToYml(Field field) {
        YmlField ymlField = new YmlField(field.getName());
        ymlField.setDataType(field.getDataType().name());
        if (field.getDataType() == DataType.ENUM) {
            ymlField.setEnumName(field.getDbEnum().getName());
        }
        ymlField.setNullable(field.isNullable());
        ymlField.setArray(field.isArray());
        ymlField.setDefaultValue(field.getDefaultValue());
        ymlField.setPrecision(field.getPrecision());
        ymlField.setScale(field.getScale());
        ymlField.setLength(field.getLength());
        ymlField.setSequence(field.isSequence());
        ymlField.setSqlForNew(field.getSqlForNew());
        return ymlField;
    }

    private YmlRuleConstraint mapToYml(RuleConstraint constraint) {
        YmlRuleConstraint ymlConstraint = new YmlRuleConstraint(constraint.getName());
        ymlConstraint.setRule(constraint.getRule());
        return ymlConstraint;
    }

    private YmlIndex mapToYml(Index index) {
        YmlIndex ymlIndex = new YmlIndex(index.getName());
        ymlIndex.setPrimary(index.isPrimary());
        ymlIndex.setUnique(index.isUnique());
        ymlIndex.setWhere(index.getWhere());
        ymlIndex.setFields(CollectorsHelper.createSchemaItemNameArray((Collection)index.getFields()));
        return ymlIndex;
    }

    private YmlForeignKey mapToYml(ForeignKey foreignKey) {
        YmlForeignKey ymlForeignKey = new YmlForeignKey(foreignKey.getName());
        ymlForeignKey.setField(foreignKey.getField().getName());
        ymlForeignKey.setTargetIndex(foreignKey.getTargetIndex().getName());
        ymlForeignKey.setTargetTable(foreignKey.getTargetIndex().getTable().getName());
        return ymlForeignKey;
    }

    private Table mapToTargetTable(Table table) {
        return this.targetSchema.getTable(table.getName());
    }

    public void close() {
    }
}

