/*
 * Decompiled with CFR 0.152.
 */
package ch.fortysix.resourcebundle.processor;

import ch.fortysix.resourcebundle.annotation.ResourceBundle;
import ch.fortysix.resourcebundle.annotation.ResourceBundleImplementationType;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.text.CaseUtils;

@SupportedAnnotationTypes(value={"ch.fortysix.resourcebundle.annotation.ResourceBundle"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value=Processor.class)
public class ResourceBundleProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> bundleClasses = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : bundleClasses) {
                Messager messager = this.processingEnv.getMessager();
                TypeElement bundleClass = (TypeElement)element;
                ResourceBundle bundleAnnotation = bundleClass.getAnnotation(ResourceBundle.class);
                ResourceBundleImplementationType type = bundleAnnotation.type();
                try {
                    messager.printMessage(Diagnostic.Kind.NOTE, "generating Message class for " + bundleAnnotation.bundle(), bundleClass);
                    Properties props = this.loadBundleMessages(bundleAnnotation);
                    Set<Map.Entry<Object, Object>> propertiesEntries = props.entrySet();
                    HashMap<String, List<String>> methodDefinitions = new HashMap<String, List<String>>();
                    for (Map.Entry<Object, Object> entry : propertiesEntries) {
                        List<String> arguments = this.getArguments((String)entry.getValue());
                        methodDefinitions.put(String.valueOf(entry.getKey()), arguments);
                    }
                    this.writeMessagesJavaFile(type, bundleAnnotation.bundle(), bundleClass.getQualifiedName().toString(), bundleAnnotation.suffix(), methodDefinitions);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return true;
    }

    private Properties loadBundleMessages(ResourceBundle bundleAnnotation) throws IOException {
        Properties props = new Properties();
        Object[] filesToAnalyse = bundleAnnotation.filesToAnalyse();
        if (ArrayUtils.isNotEmpty((Object[])filesToAnalyse)) {
            for (Object bundleFileName : filesToAnalyse) {
                this.loadProperties(props, (String)bundleFileName);
            }
        } else {
            String bundleName = bundleAnnotation.bundle();
            String bundleFileName = bundleName.replace(".properties", "").replace('.', '/').concat(".properties");
            this.loadProperties(props, bundleFileName);
        }
        return props;
    }

    private void loadProperties(Properties props, String bundleFileName) throws IOException {
        FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", bundleFileName);
        try (InputStream inputStream = fileObject.openInputStream();){
            props.load(inputStream);
        }
    }

    private void writeMessagesJavaFile(ResourceBundleImplementationType type, String bundleName, String className, String suffix, Map<String, List<String>> methodDefinitions) throws IOException {
        String packageName = null;
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            packageName = className.substring(0, lastDot);
        }
        String fullQualifiedClassName = className + suffix;
        String simpleClassName = fullQualifiedClassName.substring(lastDot + 1);
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(fullQualifiedClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            if (packageName != null) {
                out.print("package ");
                out.print(packageName);
                out.println(";");
                out.println();
            }
            out.println("import java.text.MessageFormat;");
            out.println("import java.util.HashMap;");
            out.println("import java.util.Locale;");
            out.println("import java.util.Map;");
            out.println("import java.util.MissingResourceException;");
            out.println("import java.util.ResourceBundle;");
            out.println("import java.util.concurrent.ConcurrentHashMap;");
            out.println();
            if (ResourceBundleImplementationType.COMMONS_TEXT.equals((Object)type)) {
                out.println("import org.apache.commons.text.StringSubstitutor;");
            }
            out.println();
            out.print("public class ");
            out.print(simpleClassName);
            out.println(" {");
            out.println();
            this.printHolder(bundleName, out);
            out.println();
            out.println("\tprivate Holder holder = new Holder();");
            out.println();
            methodDefinitions.forEach((key, arguments) -> {
                if (ResourceBundleImplementationType.COMMONS_TEXT.equals((Object)type)) {
                    this.commonsTextMethod(out, (String)key, (List<String>)arguments);
                } else {
                    this.javaLangMethod(out, (String)key, (List<String>)arguments);
                }
            });
            out.println("}");
        }
    }

    private void printHolder(String bundleName, PrintWriter out) {
        out.println("\tprivate static final class Holder {");
        out.println("\t\tprivate static final String BUNDLE_NAME = \"" + bundleName + "\";");
        out.println("\t\tprivate Map<Locale, ResourceBundle> bundles = new ConcurrentHashMap<>();");
        out.println();
        out.println("\t\tpublic ResourceBundle getBundle(Locale locale) {");
        out.println("\t\t\treturn bundles.computeIfAbsent(locale, l -> ResourceBundle.getBundle(BUNDLE_NAME, l));");
        out.println("\t\t}");
        out.println("\t}");
    }

    private void commonsTextMethod(PrintWriter out, String messageKey, List<String> arguments) {
        String methodName = RegExUtils.removeAll((String)CaseUtils.toCamelCase((String)messageKey, (boolean)false, (char[])new char[]{'_', '.'}), (String)"([\\.|_])");
        out.print("    public String ");
        out.print(methodName);
        out.print("(");
        out.print("Locale locale");
        for (String arg : arguments) {
            out.print(", Object ");
            out.print(arg);
        }
        out.println(") {");
        if (arguments.isEmpty()) {
            out.println("\t\ttry {");
            out.println("\t\t\treturn holder.getBundle(locale).getString(\"" + messageKey + "\");");
            out.println("\t\t} catch (MissingResourceException e) {");
            out.println("\t\t\treturn \"[" + messageKey + "]\";");
            out.println("\t\t}");
        } else {
            out.println("\t\ttry {");
            out.println("\t\t\tString messagePattern = holder.getBundle(locale).getString(\"" + messageKey + "\");");
            out.println("\t\t\tMap<String, Object> values = new HashMap<>();");
            for (String arg : arguments) {
                out.println("\t\t\tvalues.put(\"" + arg + "\", " + arg + ");");
            }
            out.println("\t\t\tStringSubstitutor sub = new StringSubstitutor(values, \"{\", \"}\");");
            out.println("\t\t\treturn sub.replace(messagePattern);");
            out.println("\t\t} catch (MissingResourceException e) {");
            out.println("\t\t\treturn \"[" + messageKey + "]\";");
            out.println("\t\t}");
        }
        out.println("    }");
        out.println();
    }

    private void javaLangMethod(PrintWriter out, String messageKey, List<String> arguments) {
        String methodName = RegExUtils.removeAll((String)CaseUtils.toCamelCase((String)messageKey, (boolean)false, (char[])new char[]{'_', '.'}), (String)"([\\.|_])");
        out.print("    public String ");
        out.print(methodName);
        out.print("(");
        out.print("Locale locale");
        for (String arg : arguments) {
            out.print(", Object ");
            out.print(arg);
        }
        out.println(") {");
        if (arguments.isEmpty()) {
            out.println("\t\ttry {");
            out.println("\t\t\treturn holder.getBundle(locale).getString(\"" + messageKey + "\");");
            out.println("\t\t} catch (MissingResourceException e) {");
            out.println("\t\t\treturn \"[" + messageKey + "]\";");
            out.println("\t\t}");
        } else {
            out.println("\t\ttry {");
            out.println("\t\t\tString messagePattern = holder.getBundle(locale).getString(\"" + messageKey + "\");");
            out.println("\t\t\treturn MessageFormat.format(messagePattern, " + this.buildArgList(arguments) + ");");
            out.println("\t\t} catch (MissingResourceException e) {");
            out.println("\t\t\treturn \"[" + messageKey + "]\";");
            out.println("\t\t}");
        }
        out.println("    }");
        out.println();
    }

    private List<String> getArguments(String messageValue) {
        int nrOfArguments = messageValue.split("(\\{\\d\\})", -1).length - 1;
        if (nrOfArguments > 0) {
            return IntStream.rangeClosed(1, nrOfArguments).mapToObj(i -> "arg" + (i - 1)).collect(Collectors.toList());
        }
        ArrayList<String> arguments = new ArrayList<String>();
        Pattern argPattern = Pattern.compile("\\{(\\w+)\\}");
        Matcher matcher = argPattern.matcher(messageValue);
        while (matcher.find()) {
            arguments.add(matcher.group(1));
        }
        return arguments;
    }

    private String buildArgList(List<String> arguments) {
        return arguments.stream().collect(Collectors.joining(", "));
    }
}

