/*
 * Decompiled with CFR 0.152.
 */
package idx.util.caching;

import idx.util.caching.NamedCache;
import java.net.URI;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GenericCacheProducer {
    private static final Logger logger = LoggerFactory.getLogger(GenericCacheProducer.class);
    private static final String CACHE_CONFIG = "/ehcache.xml";

    private URI getCacheConfig() {
        try {
            return this.getClass().getResource(CACHE_CONFIG).toURI();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to get cache config from /ehcache.xml", ex);
        }
    }

    @Produces
    @NamedCache
    public <K, V> Cache<K, V> createCache(InjectionPoint injectionPoint) {
        NamedCache annotation;
        String name;
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = Caching.getCachingProvider().getCacheManager(this.getCacheConfig(), this.getClass().getClassLoader());
        Cache cache = cacheManager.getCache(name = (annotation = (NamedCache)injectionPoint.getAnnotated().getAnnotation(NamedCache.class)).name());
        if (cache == null) {
            logger.debug("creating cache: " + name);
            Configuration config = this.createConfiguration();
            cache = cacheManager.createCache(name, config);
        } else {
            logger.debug("using preconfigured cache: " + name);
        }
        return cache;
    }

    private Configuration createConfiguration() {
        MutableConfiguration config = new MutableConfiguration();
        config.setTypes(Object.class, Object.class);
        config.setStoreByValue(true);
        config.setStatisticsEnabled(true);
        config.setManagementEnabled(true);
        return config;
    }
}

