/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import java.util.function.Consumer;
import java.util.regex.Pattern;

public final class CheckString {
    private CheckString() {
    }

    public static Consumer<String> notEmpty() {
        return value -> {
            if (value.length() == 0) {
                throw new IllegalArgumentException("must not be empty");
            }
        };
    }

    public static Consumer<String> notBlank() {
        return value -> {
            if (value.trim().length() == 0) {
                throw new IllegalArgumentException("must not be empty");
            }
        };
    }

    public static Consumer<String> format(Pattern pattern) {
        return CheckString.format(pattern, null);
    }

    public static Consumer<String> format(Pattern pattern, String hint) {
        return value -> {
            if (pattern != null && !pattern.matcher((CharSequence)value).matches()) {
                StringBuilder builder = new StringBuilder();
                builder.append("invalid format");
                if (hint != null) {
                    builder.append(" (");
                    builder.append(hint);
                    builder.append(")");
                }
                throw new IllegalArgumentException(builder.toString());
            }
        };
    }

    public static Consumer<String> min(int min) {
        return value -> {
            if (value.length() < min) {
                throw new IllegalArgumentException("must have at least " + min + " characters");
            }
        };
    }

    public static Consumer<String> max(int max) {
        return value -> {
            if (value.length() > max) {
                throw new IllegalArgumentException("must have no more than " + max + " characters");
            }
        };
    }
}

