/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import ch.frostnova.util.check.Verify;
import java.math.BigDecimal;

public final class CheckNumber {
    private CheckNumber() {
    }

    public static Verify<Number> finite() {
        return value -> {
            if (value instanceof Float ? !Float.isFinite(((Float)value).floatValue()) : value instanceof Double && !Double.isFinite((Double)value)) {
                throw new IllegalArgumentException("is not a finite number");
            }
        };
    }

    public static Verify<Number> min(Number min) {
        if (CheckNumber.isNaN(min) || CheckNumber.isNegativeInfinity(min)) {
            return value -> {};
        }
        if (CheckNumber.isPositiveInfinity(min)) {
            return value -> {
                if (!CheckNumber.isPositiveInfinity(value)) {
                    throw new IllegalArgumentException("must be " + min);
                }
            };
        }
        return value -> {
            if (!(min == null || CheckNumber.isPositiveInfinity(value) || CheckNumber.isNaN(value) || !CheckNumber.isNegativeInfinity(value) && new BigDecimal(value.toString()).compareTo(new BigDecimal(min.toString())) >= 0)) {
                throw new IllegalArgumentException("must not be smaller than " + min);
            }
        };
    }

    public static Verify<Number> max(Number max) {
        if (CheckNumber.isNaN(max) || CheckNumber.isPositiveInfinity(max)) {
            return value -> {};
        }
        if (CheckNumber.isNegativeInfinity(max)) {
            return value -> {
                if (!CheckNumber.isNegativeInfinity(value)) {
                    throw new IllegalArgumentException("must be " + max);
                }
            };
        }
        return value -> {
            if (!(max == null || CheckNumber.isNegativeInfinity(value) || CheckNumber.isNaN(value) || !CheckNumber.isPositiveInfinity(value) && new BigDecimal(value.toString()).compareTo(new BigDecimal(max.toString())) <= 0)) {
                throw new IllegalArgumentException("must not be larger than " + max);
            }
        };
    }

    public static Verify<Number> lessThan(Number n) {
        if (CheckNumber.isNaN(n) || CheckNumber.isPositiveInfinity(n)) {
            return value -> {};
        }
        if (CheckNumber.isNegativeInfinity(n)) {
            return value -> {
                throw new IllegalArgumentException("must be smaller than " + n + " (which it can't be, sorry)");
            };
        }
        return value -> {
            if (!(n == null || CheckNumber.isNegativeInfinity(value) || CheckNumber.isNaN(value) || !CheckNumber.isPositiveInfinity(value) && new BigDecimal(value.toString()).compareTo(new BigDecimal(n.toString())) < 0)) {
                throw new IllegalArgumentException("must be smaller than " + n);
            }
        };
    }

    public static Verify<Number> greaterThan(Number n) {
        if (CheckNumber.isNaN(n) || CheckNumber.isNegativeInfinity(n)) {
            return value -> {};
        }
        if (CheckNumber.isPositiveInfinity(n)) {
            return value -> {
                throw new IllegalArgumentException("must be greater than " + n + " (which it can't be, sorry)");
            };
        }
        return value -> {
            if (!(n == null || CheckNumber.isPositiveInfinity(value) || CheckNumber.isNaN(value) || !CheckNumber.isNegativeInfinity(value) && new BigDecimal(value.toString()).compareTo(new BigDecimal(n.toString())) > 0)) {
                throw new IllegalArgumentException("must be greater than " + n);
            }
        };
    }

    private static boolean isPositiveInfinity(Number number) {
        return number instanceof Double && number.doubleValue() == Double.POSITIVE_INFINITY || number instanceof Float && number.floatValue() == Float.POSITIVE_INFINITY;
    }

    private static boolean isNegativeInfinity(Number number) {
        return number instanceof Double && number.doubleValue() == Double.NEGATIVE_INFINITY || number instanceof Float && number.floatValue() == Float.NEGATIVE_INFINITY;
    }

    private static boolean isNaN(Number number) {
        return number instanceof Double && Double.isNaN(number.doubleValue()) || number instanceof Float && Float.isNaN(number.floatValue());
    }
}

