/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import ch.frostnova.util.check.Verify;
import java.util.regex.Pattern;

public final class CheckString {
    private static final Pattern SINGLE_WORD = Pattern.compile("\\p{IsAlphabetic}+");

    private CheckString() {
    }

    public static Verify<String> notEmpty() {
        return value -> {
            if (value.length() == 0) {
                throw new IllegalArgumentException("must not be empty");
            }
        };
    }

    public static Verify<String> notBlank() {
        return value -> {
            if (value.trim().length() == 0) {
                throw new IllegalArgumentException("must not be empty");
            }
        };
    }

    public static Verify<String> format(String pattern) {
        return CheckString.format(Pattern.compile(pattern));
    }

    public static Verify<String> format(Pattern pattern) {
        return CheckString.format(pattern, null);
    }

    public static Verify<String> format(Pattern pattern, String hint) {
        return value -> {
            if (pattern != null && !pattern.matcher((CharSequence)value).matches()) {
                StringBuilder builder = new StringBuilder();
                builder.append("invalid format");
                if (hint != null) {
                    builder.append(" (");
                    builder.append(hint);
                    builder.append(")");
                }
                throw new IllegalArgumentException(builder.toString());
            }
        };
    }

    public static Verify<String> format(String pattern, String hint) {
        return CheckString.format(Pattern.compile(pattern), hint);
    }

    public static Verify<String> min(int min) {
        return value -> {
            if (value.length() < min) {
                throw new IllegalArgumentException("must have at least " + min + " characters");
            }
        };
    }

    public static Verify<String> max(int max) {
        return value -> {
            if (value.length() > max) {
                throw new IllegalArgumentException("must have no more than " + max + " characters");
            }
        };
    }

    public static Verify<String> singleWord() {
        return Verify.that(s -> SINGLE_WORD.matcher((CharSequence)s).matches(), "must be a single word");
    }
}

