/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.jee.testbase;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.LogManager;
import javax.annotation.Resource;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class TestEnvironmentCDIExtension
implements Extension {
    private final Logger log = LoggerFactory.getLogger(TestEnvironmentCDIExtension.class);
    private final Set<Bean<?>> startupBeans = new LinkedHashSet();

    public <X> void processInjectionTarget(@Observes ProcessAnnotatedType<X> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        org.apache.deltaspike.jpa.api.transaction.Transactional deltaspikeTransactional = (org.apache.deltaspike.jpa.api.transaction.Transactional)AnnotationInstanceProvider.of(org.apache.deltaspike.jpa.api.transaction.Transactional.class);
        AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(annotatedType);
        boolean modified = false;
        if (annotatedType.isAnnotationPresent(Transactional.class)) {
            this.log.debug("processing @Transactional class: " + processAnnotatedType);
            builder.addToClass((Annotation)deltaspikeTransactional);
            modified = true;
        }
        for (AnnotatedMethod method : annotatedType.getMethods()) {
            if (!method.isAnnotationPresent(Transactional.class)) continue;
            this.log.debug("processing @Transactional method: " + method);
            builder.addToMethod(method, (Annotation)deltaspikeTransactional);
            modified = true;
        }
        if (annotatedType.isAnnotationPresent(Singleton.class)) {
            this.log.debug("processing @Singleton class: " + processAnnotatedType);
            builder.addToClass(AnnotationInstanceProvider.of(Stateful.class));
            builder.addToClass(AnnotationInstanceProvider.of(ApplicationScoped.class));
            builder.addToClass(AnnotationInstanceProvider.of(Transactional.class));
            builder.addToClass((Annotation)deltaspikeTransactional);
            modified = true;
        }
        if (annotatedType.isAnnotationPresent(Stateful.class) || annotatedType.isAnnotationPresent(Stateless.class) || annotatedType.isAnnotationPresent(Singleton.class) || annotatedType.isAnnotationPresent(MessageDriven.class)) {
            this.log.debug("processing EJB class: " + processAnnotatedType);
            builder.addToClass((Annotation)deltaspikeTransactional);
            modified = true;
        }
        for (AnnotatedField field : annotatedType.getFields()) {
            if (!field.isAnnotationPresent(Resource.class) || !ExecutorService.class.isAssignableFrom(field.getJavaMember().getType())) continue;
            builder.addToField(field, AnnotationInstanceProvider.of(Inject.class));
            modified = true;
        }
        if (modified) {
            processAnnotatedType.setAnnotatedType(builder.create());
        }
    }

    private <X> void processBean(@Observes ProcessBean<X> event) {
        Annotated annotated = event.getAnnotated();
        if (annotated.isAnnotationPresent(Startup.class) && (annotated.isAnnotationPresent(Singleton.class) || annotated.isAnnotationPresent(ApplicationScoped.class))) {
            this.log.debug("tracking @Startup bean: " + event.getBean().getBeanClass());
            this.startupBeans.add(event.getBean());
        }
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        TestEnvironmentCDIExtension.initLogging();
        ContextControl ctxCtrl = (ContextControl)BeanProvider.getContextualReference(ContextControl.class, (Annotation[])new Annotation[0]);
        ctxCtrl.startContext(ApplicationScoped.class);
        ctxCtrl.startContext(RequestScoped.class);
        for (Bean<?> bean : this.startupBeans) {
            this.log.debug("starting @Startup bean: " + bean.getBeanClass());
            manager.getReference(bean, (Type)bean.getBeanClass(), manager.createCreationalContext(bean)).toString();
        }
        this.startupBeans.clear();
    }

    private static void initLogging() {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

