/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.keygen;

import ch.frostnova.keygen.alphabet.Alphabet;
import ch.frostnova.keygen.alphabet.AlphabetCodec;
import ch.frostnova.keygen.model.KeyLengthUnit;
import ch.frostnova.keygen.model.KeySpec;
import ch.frostnova.keygen.model.KeyType;
import ch.frostnova.util.check.Check;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class KeyGenerator {
    public static void main(String[] args) {
        if (args.length != 1) {
            KeyGenerator.printUsage();
            System.exit(1);
        }
        try {
            KeySpec keySpec = new KeySpec(args[0]);
            System.out.println("Key Spec: " + keySpec);
            System.out.println("Key strength [bits]: " + keySpec.getStrengthInBits());
            System.out.println(KeyGenerator.generate(keySpec));
        }
        catch (Exception ex) {
            System.err.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
            KeyGenerator.printUsage();
            System.exit(1);
        }
    }

    private KeyGenerator() {
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar secure-keygen.jar {keyspec}");
        System.out.println("   {keyspec}: Key specification in the format {keytypes}{lenght}{lengthunit}");
        System.out.println("example keyspecs: Numeric6Chars, AlphaNumeric256bit, Hexadecimal8bytes");
        System.out.println("supported keytypes: " + Stream.of(KeyType.values()).map(Enum::name).collect(Collectors.joining(", ")));
        System.out.println("supported lengthunits: " + Stream.of(KeyLengthUnit.values()).map(Enum::name).collect(Collectors.joining(", ")));
    }

    public static String generate(KeySpec spec) {
        return KeyGenerator.generate(spec, new SecureRandom());
    }

    public static String generate(KeySpec spec, Random random) {
        Check.required((Object)spec, (String)"OTP specification", (Consumer[])new Consumer[0]);
        Check.required((Object)random, (String)"random", (Consumer[])new Consumer[0]);
        Alphabet alphabet = spec.getType().getAlphabet();
        AlphabetCodec codec = new AlphabetCodec(alphabet);
        if (spec.getUnit() == KeyLengthUnit.Bits) {
            BigInteger value = new BigInteger(spec.getLength(), random);
            return codec.encode(value);
        }
        if (spec.getUnit() == KeyLengthUnit.Bytes) {
            BigInteger value = new BigInteger(spec.getLength() * 8, random);
            return codec.encode(value);
        }
        if (spec.getUnit() == KeyLengthUnit.Chars) {
            BigInteger value;
            BigInteger max = BigInteger.valueOf(alphabet.length()).pow(spec.getLength());
            while ((value = new BigInteger(max.bitLength(), random)).compareTo(max) >= 0) {
            }
            StringBuilder encoded = new StringBuilder(codec.encode(value));
            while (encoded.length() < spec.getLength()) {
                encoded.insert(0, alphabet.charAt(0));
            }
            return encoded.toString();
        }
        throw new IllegalStateException("Unknown unit: " + (Object)((Object)spec.getUnit()));
    }
}

