/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.keygen.alphabet.impl;

import ch.frostnova.keygen.alphabet.Alphabet;
import ch.frostnova.util.check.Check;
import ch.frostnova.util.check.CheckString;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class PredefinedAlphabet
implements Alphabet {
    private final List<Character> characters = new ArrayList<Character>();

    public PredefinedAlphabet(String stringWithCharacters) {
        Check.required((Object)stringWithCharacters, (String)stringWithCharacters, (Consumer[])new Consumer[]{CheckString.min((int)1)});
        for (char c : stringWithCharacters.toCharArray()) {
            if (this.characters.contains(Character.valueOf(c))) continue;
            this.characters.add(Character.valueOf(c));
        }
        if (this.characters.size() < 2) {
            throw new IllegalArgumentException("Alphabet must consist of at least two distinct characters");
        }
    }

    @Override
    public int length() {
        return this.characters.size();
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.characters.get(index).charValue();
    }

    @Override
    public int indexOf(char c) {
        int index = this.characters.indexOf(Character.valueOf(c));
        if (index < 0) {
            throw new NoSuchElementException();
        }
        return index;
    }
}

