/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.keygen.model;

import ch.frostnova.util.check.Check;
import ch.frostnova.util.check.CheckString;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public enum KeyLengthUnit {
    Bits("Bit"),
    Bytes("Byte"),
    Chars("Char", "Characters", "Digit", "Digits");

    private String[] aliases;

    private KeyLengthUnit(String ... aliases) {
        this.aliases = aliases;
    }

    public static KeyLengthUnit parse(String input) {
        input = ((String)Check.required((Object)input, (String)"input", (Consumer[])new Consumer[]{CheckString.notBlank()})).trim();
        for (KeyLengthUnit value : KeyLengthUnit.values()) {
            if (value.name().equalsIgnoreCase(input)) {
                return value;
            }
            for (String alias : value.aliases) {
                if (!alias.equalsIgnoreCase(input)) continue;
                return value;
            }
        }
        throw new NoSuchElementException("No such " + KeyLengthUnit.class.getSimpleName() + ": " + input);
    }
}

