/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.keygen.model;

import ch.frostnova.util.check.Check;
import ch.frostnova.util.check.CheckString;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class KeyPattern {
    public static final KeyPattern UUID = new KeyPattern("########-####-####-####-#############");
    public static final KeyPattern LICENSE_KEY = new KeyPattern("####-*");
    private static final Pattern FORMAT = Pattern.compile("([^\\*]*#[^\\*]*)+\\*?");
    private final String pattern;

    public KeyPattern(String pattern) {
        this.pattern = (String)Check.required((Object)pattern, (String)"pattern", (Consumer[])new Consumer[]{CheckString.format((Pattern)FORMAT)});
    }

    public String format(String value) {
        Check.required((Object)"value", (String)value, (Consumer[])new Consumer[0]);
        char[] patternChars = this.pattern.toCharArray();
        StringBuilder builder = new StringBuilder();
        int patternOffset = 0;
        for (char c : value.toCharArray()) {
            while (patternOffset < patternChars.length && patternChars[patternOffset] != '#') {
                if (patternChars[patternOffset] == '*') {
                    patternOffset = 0;
                    continue;
                }
                builder.append(patternChars[patternOffset]);
                ++patternOffset;
            }
            builder.append(c);
            ++patternOffset;
        }
        return builder.toString();
    }
}

