/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.keygen.model;

import ch.frostnova.keygen.model.KeyLengthUnit;
import ch.frostnova.keygen.model.KeyType;
import ch.frostnova.util.check.Check;
import ch.frostnova.util.check.CheckNumber;
import ch.frostnova.util.check.CheckString;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class KeySpec {
    private static final Pattern PATTERN = Pattern.compile("\\s*([A-Za-z]+)\\s*([0-9]+)\\s*([A-Za-z]+)\\s*");
    private final KeyType type;
    private final int length;
    private final KeyLengthUnit unit;

    public KeySpec(KeyType type, int length, KeyLengthUnit unit) {
        this.type = (KeyType)((Object)Check.required((Object)((Object)type), (String)"type", (Consumer[])new Consumer[0]));
        this.length = (Integer)Check.required((Object)length, (String)"length", (Consumer[])new Consumer[]{CheckNumber.min((Number)1)});
        this.unit = (KeyLengthUnit)((Object)Check.required((Object)((Object)unit), (String)"unit", (Consumer[])new Consumer[0]));
    }

    public KeySpec(String specification) {
        Check.required((Object)specification, (String)"specification", (Consumer[])new Consumer[]{CheckString.notBlank()});
        Matcher matcher = PATTERN.matcher(specification);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unsupported specification: " + specification);
        }
        try {
            this.type = KeyType.parse(matcher.group(1));
            this.length = Integer.parseInt(matcher.group(2));
            this.unit = KeyLengthUnit.parse(matcher.group(3));
        }
        catch (NoSuchElementException ex) {
            throw new IllegalArgumentException("Unsupported specification: " + specification + ": " + ex.getMessage());
        }
    }

    public KeyType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getStrengthInBits() {
        if (this.unit == KeyLengthUnit.Bits) {
            return this.length;
        }
        if (this.unit == KeyLengthUnit.Bytes) {
            return this.length * 8;
        }
        if (this.unit == KeyLengthUnit.Chars) {
            return (int)(Math.log(Math.pow(this.type.getAlphabet().length(), this.length)) / Math.log(2.0));
        }
        throw new IllegalStateException("Unsuported key length unit");
    }

    public KeyLengthUnit getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.type.name() + this.length + this.unit.name();
    }
}

