/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.keygen.model;

import ch.frostnova.keygen.alphabet.Alphabet;
import ch.frostnova.keygen.alphabet.impl.AlphanumericAlphabet;
import ch.frostnova.keygen.alphabet.impl.HexadecimalAlphabet;
import ch.frostnova.keygen.alphabet.impl.NumericAlphabet;
import ch.frostnova.keygen.alphabet.impl.SaveAlphanumericAlphabet;
import ch.frostnova.keygen.alphabet.impl.VerySaveAlphanumericAlphabet;
import ch.frostnova.util.check.Check;
import ch.frostnova.util.check.CheckString;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public enum KeyType {
    Numeric(new NumericAlphabet()),
    AlphaNumeric(new AlphanumericAlphabet()),
    Hexadecimal(new HexadecimalAlphabet()),
    SaveAlphaNumeric(new SaveAlphanumericAlphabet()),
    VerySaveAlphaNumeric(new VerySaveAlphanumericAlphabet());

    private Alphabet alphabet;

    private KeyType(Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public static KeyType parse(String input) {
        input = ((String)Check.required((Object)input, (String)"input", (Consumer[])new Consumer[]{CheckString.notBlank()})).trim();
        for (KeyType value : KeyType.values()) {
            if (!value.name().equalsIgnoreCase(input)) continue;
            return value;
        }
        throw new NoSuchElementException("No such " + KeyType.class.getSimpleName() + ": " + input);
    }
}

