/*
 * Decompiled with CFR 0.152.
 */
package ch.galinet.xml.xsdhierarchy;

import ch.galinet.xml.xsdhierarchy.MapNamespaceContext;
import ch.galinet.xml.xsdhierarchy.XsdElement;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.impl.ComplexTypeImpl;
import com.sun.xml.xsom.impl.ElementDecl;
import com.sun.xml.xsom.impl.ModelGroupImpl;
import com.sun.xml.xsom.impl.ParticleImpl;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public class XsdParser {
    private final XSOMParser parser = new XSOMParser(SAXParserFactory.newInstance());

    public XsdParser(InputStream xsd) throws SAXException {
        this.parser.parse(xsd);
    }

    public XsdElement getRoot() throws SAXException {
        ElementDecl c = (ElementDecl)this.parser.getResult().selectSingle("*", (NamespaceContext)new MapNamespaceContext());
        XsdElement result = new XsdElement();
        result.setNamespace(c.getTargetNamespace());
        result.setName(c.getName());
        return result;
    }

    public List<XsdElement> getChildren(String scd, NamespaceContext ctx) throws SAXException {
        ElementDecl c = (ElementDecl)this.parser.getResult().selectSingle(scd, ctx);
        if (c != null) {
            ArrayList<XsdElement> result = new ArrayList<XsdElement>();
            ComplexTypeImpl type = (ComplexTypeImpl)c.getType();
            ParticleImpl ct = (ParticleImpl)type.getContentType();
            ModelGroupImpl term = (ModelGroupImpl)ct.getTerm();
            this.recurse(result, term);
            return result;
        }
        return null;
    }

    private void recurse(List<XsdElement> result, ModelGroupImpl term) {
        for (ParticleImpl child : term.getChildren()) {
            XSTerm xSTerm = child.getTerm();
            if (xSTerm instanceof ModelGroupImpl) {
                ModelGroupImpl modelGroupImpl = (ModelGroupImpl)xSTerm;
                this.recurse(result, modelGroupImpl);
                continue;
            }
            xSTerm = child.getTerm();
            if (xSTerm instanceof ElementDecl) {
                ElementDecl elementDecl = (ElementDecl)xSTerm;
                result.add(new XsdElement(elementDecl.getTargetNamespace(), elementDecl.getName()));
                continue;
            }
            throw new IllegalArgumentException(String.format("Type %s not implemented!", child.getTerm().getClass()));
        }
    }
}

